/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.esi.supervisor;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import com.nomagic.esi.service.IActorSystemFactory;
import com.nomagic.esi.supervisor.ISupervisorFactory;
import com.nomagic.esi.supervisor.SupervisorFactory;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupervisorComponent
implements ISupervisorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SupervisorComponent.class);
    private ISupervisorFactory supervisorFactory;
    private ActorSystem actorSystem;
    private IActorSystemFactory actorSystemFactory;
    private static volatile SupervisorComponent instance;

    public void activate(BundleContext bundleContext) {
        this.actorSystem = this.actorSystemFactory.getActorSystem();
        this.supervisorFactory = new SupervisorFactory(this.actorSystem);
        instance = this;
        LOG.info(String.valueOf(SupervisorComponent.class.getSimpleName()) + " activated");
    }

    public void deactivate(BundleContext bundleContext) {
        LOG.info(String.valueOf(SupervisorComponent.class.getSimpleName()) + " deactivated");
    }

    @Override
    public ActorRef createEsiRootActor(Props props, String string) {
        return this.supervisorFactory.createEsiRootActor(props, string);
    }

    @Override
    public ActorRef createPluginRootActor(Props props, String string) {
        return this.supervisorFactory.createPluginRootActor(props, string);
    }

    public void setActorSystemFactory(IActorSystemFactory iActorSystemFactory) {
        this.actorSystemFactory = iActorSystemFactory;
    }

    public void unsetActorSystemFactory(IActorSystemFactory iActorSystemFactory) {
        this.actorSystemFactory = null;
        this.actorSystem = null;
    }

    public ActorSystem getActorSystem() {
        return this.actorSystem;
    }

    public static SupervisorComponent getInstance() {
        return instance;
    }
}

