/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.esi.service;

import com.nomagic.esi.service.IServerStatus;
import java.util.ArrayList;

public abstract class AbstractServerStatus
implements IServerStatus {
    private IServerStatus.ServerStatus status = IServerStatus.ServerStatus.STOPPED;
    private StringBuilder messages = new StringBuilder();
    protected int maxMessages;
    private static final String CR = System.getProperty("line.separator");

    public AbstractServerStatus(int n) {
        this.maxMessages = n;
    }

    @Override
    public IServerStatus.ServerStatus getStatus() {
        return this.status;
    }

    public void setStatus(IServerStatus.ServerStatus serverStatus) {
        this.status = serverStatus;
    }

    @Override
    public String getStatusMessage() {
        return this.messages.toString();
    }

    public synchronized void addMessage(String string) {
        if (this.messages.length() > 0) {
            this.messages.append(CR);
        }
        this.messages.append(string);
        this.messages = this.stripLines(this.messages, this.maxMessages);
    }

    protected void stripMessages() {
        this.messages = this.stripLines(this.messages, this.maxMessages);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private StringBuilder stripLines(StringBuilder stringBuilder, int n) {
        if (stringBuilder == null) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return stringBuilder;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = stringBuilder.indexOf(CR);
        while (n2 != -1) {
            arrayList.add(n2);
            n2 = stringBuilder.indexOf(CR, n2 + 1);
        }
        if (arrayList.size() > 0 && (Integer)arrayList.get(arrayList.size() - 1) + CR.length() == stringBuilder.length()) {
            arrayList.remove(arrayList.size() - 1);
        }
        if (arrayList.size() >= n) {
            StringBuilder stringBuilder2 = new StringBuilder(stringBuilder.length());
            stringBuilder2.append(stringBuilder.substring((Integer)arrayList.get(arrayList.size() - n) + 1));
            return stringBuilder2;
        }
        return stringBuilder;
    }
}

