/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trinity.api;

import com.ibm.trinity.api.ProblemReasonEnum;
import com.ibm.trinity.api.RecordData;
import com.ibm.trinity.api.SpecialFieldValue;
import com.ibm.trinity.syncmodel.ConstantViewColumn;
import com.ibm.trinity.syncmodel.UnmappedViewColumn;
import com.ibm.trinity.syncmodel.ViewColumn;
import com.ibm.trinity.syncmodel.ViewLayout;
import org.eclipse.emf.common.util.EList;

public class ViewRecordData
extends RecordData {
    private static final long serialVersionUID = -1846003451655163445L;
    private ProblemReasonEnum[] problems;
    private final boolean boundToModel;

    public static ViewRecordData create(int id, boolean boundToModel) {
        return new ViewRecordData(id, null, boundToModel);
    }

    public static ViewRecordData create(ViewLayout layout, int id, Object[] cellValues) {
        return ViewRecordData.create(layout, id, cellValues, 0, cellValues.length - 1);
    }

    public static ViewRecordData create(ViewLayout layout, int id, Object[] cellValues, int changedFieldStart, int changedFieldEnd) {
        Object v;
        for (int i = cellValues.length - 1; i >= 0 && (v = cellValues[i]) instanceof String && "".equals(v); --i) {
            cellValues[i] = SpecialFieldValue.EMPTY;
        }
        boolean noUpdate = true;
        EList columns = layout.getColumns();
        assert (columns.size() == cellValues.length);
        for (int i = 0; i < cellValues.length; ++i) {
            ViewColumn col = (ViewColumn)columns.get(i);
            if (col instanceof ConstantViewColumn) {
                ConstantViewColumn cvc = (ConstantViewColumn)col;
                if (cvc.getValue().equals(cellValues[i])) continue;
                cellValues[i] = null;
                continue;
            }
            if (col instanceof UnmappedViewColumn) {
                cellValues[i] = SpecialFieldValue.UNMAPPED;
                continue;
            }
            Object v2 = cellValues[i];
            if (v2 == null && (col.isAlternative() || col.isOptional())) {
                cellValues[i] = SpecialFieldValue.VOID;
            }
            if (!noUpdate || i < changedFieldStart || i > changedFieldEnd) continue;
            noUpdate = false;
        }
        if (noUpdate) {
            return null;
        }
        return new ViewRecordData(id, cellValues, false);
    }

    private ViewRecordData(int id, Object[] fields, boolean boundToModel) {
        super(id, fields);
        this.boundToModel = boundToModel;
    }

    public ViewRecordData(int id, Object[] fields, ProblemReasonEnum[] problems, boolean boundToModel) {
        super(id, fields);
        if (fields == null) {
            throw new IllegalArgumentException();
        }
        if (problems == null) {
            throw new IllegalArgumentException();
        }
        if (fields.length != problems.length) {
            throw new IllegalArgumentException("array size mismatch: fields=" + fields.length + ", problems=" + problems.length);
        }
        this.problems = problems;
        this.boundToModel = boundToModel;
    }

    public boolean hasProblem() {
        if (this.problems != null) {
            for (ProblemReasonEnum p : this.problems) {
                if (p == null) continue;
                return true;
            }
        }
        return false;
    }

    public boolean revertAll() {
        for (int i = 0; i < this.problems.length; ++i) {
            if (this.problems[i].getRevert() != ProblemReasonEnum.Revert.ALL) continue;
            return true;
        }
        return false;
    }

    public ProblemReasonEnum[] getProblems() {
        return this.problems;
    }

    public boolean isBoundToModel() {
        return this.boundToModel;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        boolean first = true;
        if (this.getProblems() != null) {
            sb.append(" {");
            for (ProblemReasonEnum p : this.getProblems()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append((Object)p);
            }
            sb.append('}');
        }
        return sb.toString();
    }
}

