/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trinity.api;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.adaptor.EclipseStarter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public abstract class TrinityLauncher {
    public static final String NAME = "IBM Model Spreadsheet Platform Plugin";
    public static final String TRINITY_BACKEND_BUNDLE_NAME = "com.ibm.trinity.backend";
    public static final String TRINITY_FRONTEND_BUNDLE_NAME = "com.ibm.trinity.frontend";
    public static final String PROPERTIES_FILE = "TrinityBackend.properties";
    public static final String PROP_RMI_NAME = "com.ibm.trinity.backend.rmi_name";
    public static final String PROP_RMI_PORT = "com.ibm.trinity.backend.rmi_port";
    protected static final boolean DEBUG = true;
    private String backendServiceURI;
    private Bundle backendBundle;
    private Bundle frontendBundle;

    protected TrinityLauncher() {
    }

    protected void infoLog(String msg) {
        System.out.println(msg);
    }

    protected void debugLog(String msg) {
        System.out.println(msg);
    }

    protected abstract String getMyPluginLocation();

    protected abstract String getCurrentDirectory();

    static String toFileURI(String path) {
        if (path == null) {
            throw new IllegalArgumentException();
        }
        File f = new File(path);
        try {
            File canonFile = f.getCanonicalFile();
            URI u = canonFile.toURI();
            return u.toString();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(path, e);
        }
    }

    private Map<String, String> getDefaultOSGiLaunchParameters() {
        HashMap<String, String> props = new HashMap<String, String>();
        String pluginFolder = this.getMyPluginLocation();
        props.put("osgi.install.area", pluginFolder + "\\eclipse");
        props.put("osgi.configuration.area", pluginFolder + "\\eclipse\\configuration");
        props.put("osgi.instance.area", pluginFolder + "\\workspace");
        return props;
    }

    private String[] loadOSGiLaunchArguments(Map<String, String> props) {
        String pluginFolder = this.getMyPluginLocation();
        ArrayList<String> args = new ArrayList<String>();
        File dir = new File(pluginFolder, "eclipse");
        File f = new File(dir, "eclipse.ini");
        try {
            if (f.exists()) {
                String line;
                FileInputStream inStream = new FileInputStream(f);
                BufferedReader r = new BufferedReader(new InputStreamReader(inStream));
                while ((line = r.readLine()) != null) {
                    if (line.charAt(0) == '#') continue;
                    if ((line = line.trim()).startsWith("-D")) {
                        String s = line.substring(2);
                        String[] ss = s.split("=", 2);
                        if (ss.length == 1) {
                            props.put(ss[0], "");
                            continue;
                        }
                        if (ss.length <= 1) continue;
                        props.put(ss[0], ss[1]);
                        continue;
                    }
                    args.add(line);
                }
                r.close();
            }
            return args.toArray(new String[args.size()]);
        }
        catch (IOException e) {
            this.infoLog("Skipped to load OSGi launch parameter file: " + f.getAbsolutePath());
            return new String[0];
        }
    }

    private BundleContext startEclipse() throws Exception {
        Map<String, String> props = this.getDefaultOSGiLaunchParameters();
        String[] args = this.loadOSGiLaunchArguments(props);
        EclipseStarter.setInitialProperties(props);
        BundleContext bundleContext = EclipseStarter.startup((String[])args, null);
        return bundleContext;
    }

    private String startupTrinityBackend(BundleContext bundleContext) throws Exception {
        Bundle[] bundles = bundleContext.getBundles();
        if (bundles != null) {
            for (Bundle b : bundles) {
                if (!TRINITY_BACKEND_BUNDLE_NAME.equals(b.getSymbolicName())) continue;
                this.backendBundle = b;
                b.start();
                Enumeration e = b.findEntries("", PROPERTIES_FILE, false);
                if (!e.hasMoreElements()) continue;
                URL url = (URL)e.nextElement();
                Properties trinityProps = new Properties();
                try {
                    trinityProps.load(url.openStream());
                    String name = trinityProps.getProperty(PROP_RMI_NAME);
                    String sPort = trinityProps.getProperty(PROP_RMI_PORT);
                    int port = Integer.parseInt(sPort);
                    return "rmi://localhost:" + port + "/" + name;
                }
                catch (IOException ioe) {
                    this.infoLog("Failed to read Trinity Backend properties file at " + url);
                }
                catch (NumberFormatException nfe) {
                    this.infoLog("Failed to parse Trinity Backed property 'com.ibm.trinity.backend.rmi_port' in " + url);
                }
            }
        }
        this.backendBundle = null;
        this.infoLog("Trinity Backend OSGi Bundle was not found: com.ibm.trinity.backend");
        return null;
    }

    private void shutdownTrinityBackend() throws Exception {
        if (this.frontendBundle != null) {
            this.frontendBundle.stop();
            this.frontendBundle = null;
        }
        if (this.backendBundle != null) {
            this.backendBundle.stop();
            this.backendBundle = null;
        }
        if (EclipseStarter.isRunning()) {
            EclipseStarter.shutdown();
        }
    }

    private boolean isTrinityBackendRunning() {
        return EclipseStarter.isRunning() && this.backendBundle != null && this.backendBundle.getState() == 32;
    }

    public void start(String modelURI, String trinityTemplateURI) {
        this.start(modelURI, trinityTemplateURI, null);
    }

    public synchronized void start(String modelURI, String trinityTemplateURI, String excelTemplate) {
        this.debugLog("TrinityLauncher.start: trinityTemplateURI=" + trinityTemplateURI + ", excelTemplate=" + excelTemplate);
        BundleContext bundleContext = null;
        if (!EclipseStarter.isRunning()) {
            try {
                bundleContext = this.startEclipse();
            }
            catch (Exception e) {
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                PrintWriter w = new PrintWriter(buf);
                e.printStackTrace(w);
                w.flush();
                w.close();
                this.infoLog(buf.toString());
                return;
            }
        }
        if (!this.isTrinityBackendRunning()) {
            this.debugLog("Try to start Trintiy Backend");
            try {
                this.backendServiceURI = this.startupTrinityBackend(bundleContext);
                this.debugLog("Trinity Backend Service is ready at " + this.backendServiceURI);
            }
            catch (Throwable t) {
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                PrintWriter w = new PrintWriter(buf);
                t.printStackTrace(w);
                w.flush();
                w.close();
                this.infoLog(buf.toString());
                return;
            }
        }
        try {
            String curDir = this.getCurrentDirectory();
            ArrayList<Object> cmdList = new ArrayList<Object>(7);
            cmdList.add("wscript.exe");
            cmdList.add(this.getMyPluginLocation() + "\\RhpTrinityFE.wsf");
            cmdList.add("//Nologo");
            cmdList.add("-dir");
            cmdList.add(curDir);
            cmdList.add(this.backendServiceURI);
            cmdList.add(modelURI);
            cmdList.add(trinityTemplateURI);
            if (excelTemplate != null) {
                cmdList.add(excelTemplate);
            }
            String[] cmds = cmdList.toArray(new String[0]);
            this.debugLog("Try to open Trinity Frontend: " + Arrays.toString(cmdList.toArray()));
            Runtime.getRuntime().exec(cmds);
            this.debugLog("Trinity Frontend started\n");
        }
        catch (Exception e) {
            e.fillInStackTrace();
            this.infoLog("Failed to start Trinity Frontend\n");
            try {
                this.shutdownTrinityBackend();
                this.debugLog("Trinity Backend Service is stopped\n");
            }
            catch (Exception ee) {
                ee.fillInStackTrace();
                throw new IllegalStateException("Failed to shutdown Trinity backend", ee);
            }
        }
    }
}

