/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trinity.api;

import com.ibm.trinity.api.InvalidParameterException;
import com.ibm.trinity.api.LicenseException;
import com.ibm.trinity.api.SaveOptionEnum;
import com.ibm.trinity.api.SyncViewTransactionLog;
import com.ibm.trinity.api.SyncViewTransactionLogSet;
import com.ibm.trinity.api.SyncViewVersionMap;
import com.ibm.trinity.api.SyncViewVersionMismatchException;
import com.ibm.trinity.api.TrinityBackendService;
import com.ibm.trinity.api.TrinityRuntimeException;
import com.ibm.trinity.api.TrinityStatus;
import com.ibm.trinity.api.ViewRecordData;
import com.ibm.trinity.api.ViewRecordDataSet;
import com.ibm.trinity.dsl.SyncModelStandaloneSetup;
import com.ibm.trinity.syncmodel.SyncModel;
import com.ibm.trinity.syncmodel.ViewLayout;
import com.ibm.trinity.syncmodel.WorksheetDef;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;

public abstract class TrinityConnection
implements Serializable {
    private static final long serialVersionUID = -2910294356981919107L;
    private final int sessionId;
    private final TrinityBackendService service;

    protected TrinityConnection(int sessionId, TrinityBackendService service) {
        if (sessionId == 0) {
            throw new IllegalArgumentException("SessionID is 0");
        }
        this.sessionId = sessionId;
        this.service = service;
        SyncModelStandaloneSetup.doSetup();
    }

    public void open() {
    }

    public void disconnect() throws RemoteException {
        this.service.disconnect(this.sessionId);
    }

    public int getSessionId() {
        return this.sessionId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append("[sessionId=").append(this.sessionId).append(']');
        return sb.toString();
    }

    public abstract SyncModel getSyncModel();

    public abstract Object getMPAdapterSpecification();

    public abstract String loadModel(String var1) throws InvalidParameterException, LicenseException, IOException;

    public abstract String save(SaveOptionEnum var1);

    public abstract SyncViewTransactionLogSet reload(SyncViewVersionMap var1, Map<?, ?> var2) throws TrinityRuntimeException, InterruptedException, SyncViewVersionMismatchException;

    public abstract String saveAs(String var1);

    public abstract String saveCopyAs(String var1);

    public abstract String getModelFileExtension();

    public abstract TrinityStatus getStatus();

    public abstract String testRetrieveModelFilePath();

    public abstract boolean isModified();

    public abstract ViewRecordDataSet getRecords(String var1) throws TrinityRuntimeException, InterruptedException;

    public abstract int[] reserveRecordIds(String var1, int var2, int var3) throws TrinityRuntimeException, SyncViewVersionMismatchException;

    public abstract SyncViewTransactionLogSet updateRecords(String var1, SyncViewVersionMap var2, ViewRecordData[] var3) throws TrinityRuntimeException, InterruptedException, SyncViewVersionMismatchException;

    public abstract SyncViewTransactionLogSet deleteRecords(String var1, SyncViewVersionMap var2, int[] var3) throws TrinityRuntimeException, InterruptedException, SyncViewVersionMismatchException;

    public abstract SyncViewTransactionLogSet undo(int var1, SyncViewVersionMap var2) throws TrinityRuntimeException, InterruptedException, SyncViewVersionMismatchException;

    public abstract SyncViewTransactionLogSet redo(SyncViewVersionMap var1) throws TrinityRuntimeException, InterruptedException, SyncViewVersionMismatchException;

    public abstract boolean isReloadRefreshSuccessful();

    public abstract SyncViewTransactionLog[] getTransactionLogs(String var1, int var2) throws TrinityRuntimeException, InterruptedException;

    public abstract String loadSyncView(ViewLayout var1, WorksheetDef var2) throws TrinityRuntimeException, InterruptedException;

    public abstract void notifyClientVersion(String var1, int var2);

    public abstract String dumpInternalState() throws RemoteException;

    public abstract SyncViewTransactionLogSet refresh(SyncViewVersionMap var1) throws TrinityRuntimeException, InterruptedException, SyncViewVersionMismatchException;

    public abstract SyncViewTransactionLogSet evaluateFormulas(String var1, Object var2, SyncViewVersionMap var3) throws TrinityRuntimeException, InterruptedException, SyncViewVersionMismatchException;

    public abstract SyncViewTransactionLogSet clean(SyncViewVersionMap var1);

    public Object runCommand(CommandType type, CommandArg arg) {
        throw new UnsupportedOperationException("TODO");
    }

    public EObject getObservedEObject(String syncViewName, String id) {
        throw new UnsupportedOperationException("TODO");
    }

    public static class CommandArg {
        private Object range;
        private int colCellid;
        private List<Object> cellData;
        private EObject eObject;
        private String syncViewName;
        private SyncViewVersionMap versionMap;

        private CommandArg(CommandArgBuilder builder) {
            this.range = builder.range;
            this.colCellid = builder.colCellid;
            this.cellData = builder.cellData;
            this.eObject = builder.eo;
            this.syncViewName = builder.syncViewName;
            this.versionMap = builder.versionMap;
        }

        public Object getRange() {
            return this.range;
        }

        public int getColCellid() {
            return this.colCellid;
        }

        public List<Object> getCellData() {
            return this.cellData;
        }

        public EObject getEObject() {
            return this.eObject;
        }

        public String getSyncViewName() {
            return this.syncViewName;
        }

        public SyncViewVersionMap getVersionMap() {
            return this.versionMap;
        }
    }

    public static class CommandArgBuilder {
        private Object range;
        private int colCellid;
        private List<Object> cellData;
        private EObject eo;
        private String syncViewName;
        private SyncViewVersionMap versionMap;

        public CommandArgBuilder() {
        }

        public CommandArgBuilder(Object range) {
            this.range = range;
        }

        public CommandArgBuilder range(Object range) {
            this.range = range;
            return this;
        }

        public CommandArgBuilder colCellid(int colCellid) {
            this.colCellid = colCellid;
            return this;
        }

        public CommandArgBuilder cellData(List<Object> cellData) {
            this.cellData = cellData;
            return this;
        }

        public CommandArgBuilder eObject(EObject eo) {
            this.eo = eo;
            return this;
        }

        public CommandArgBuilder syncViewName(String syncViewName) {
            this.syncViewName = syncViewName;
            return this;
        }

        public CommandArgBuilder versionMap(SyncViewVersionMap versionMap) {
            this.versionMap = versionMap;
            return this;
        }

        public CommandArg build() {
            return new CommandArg(this);
        }
    }

    public static enum CommandType {
        IS_SHARED_INSTANCE_SUPPORTED,
        CREATE_SHARED_INSTANCE,
        UNSHARED_INSTANCE,
        SET,
        UNSET;

    }
}

