/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trinity.api;

import com.ibm.trinity.api.ProblemReasonEnum;
import com.ibm.trinity.api.SpecialFieldValue;
import com.ibm.trinity.api.ViewRecordData;
import java.io.Serializable;

public class SyncViewChangeLog
implements Serializable {
    private static final long serialVersionUID = -3285791943537025604L;
    private Operation op;
    private ViewRecordData data;

    public static SyncViewChangeLog createDeleteLog(ViewRecordData data) {
        return new SyncViewChangeLog(Operation.DELETE, data);
    }

    public static SyncViewChangeLog createInsertLog(ViewRecordData data) {
        return new SyncViewChangeLog(Operation.INSERT, data);
    }

    public static SyncViewChangeLog createUpdateLog(ViewRecordData data) {
        return new SyncViewChangeLog(Operation.UPDATE, data);
    }

    private SyncViewChangeLog(Operation op, ViewRecordData data) {
        this.op = op;
        this.data = data;
    }

    public Operation getOp() {
        return this.op;
    }

    public ViewRecordData getRecordData() {
        return this.data;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.op.name());
        sb.append(':');
        sb.append(this.data);
        return sb.toString();
    }

    public boolean merge(SyncViewChangeLog oldLog) {
        if (oldLog != null && oldLog.getRecordData().getId() != this.data.getId()) {
            throw new IllegalArgumentException();
        }
        switch (this.op) {
            case UPDATE: {
                if (oldLog == null) {
                    return true;
                }
                if (Operation.DELETE.equals((Object)oldLog.getOp())) {
                    // empty if block
                }
                Object[] myFields = this.data.getFields();
                Object[] oldFields = oldLog.getRecordData().getFields();
                for (int i = 0; i < myFields.length; ++i) {
                    if (oldFields[i] == SpecialFieldValue.EMPTY_WRITEBACK || oldFields[i] == SpecialFieldValue.VOID_WRITEBACK) {
                        myFields[i] = oldFields[i];
                        continue;
                    }
                    if (myFields[i] != SpecialFieldValue.UNCHANGED || oldFields[i] == SpecialFieldValue.UNCHANGED) continue;
                    myFields[i] = oldFields[i];
                }
                return true;
            }
            case DELETE: {
                if (oldLog == null || Operation.DELETE.equals((Object)oldLog.getOp())) {
                    // empty if block
                }
                return true;
            }
            case INSERT: {
                return oldLog == null;
            }
        }
        throw new IllegalStateException("Unknown operation: " + this.op);
    }

    private boolean isUnchangedFrom(Object newField, Object oldField) {
        if (newField instanceof SpecialFieldValue) {
            return ((SpecialFieldValue)newField).isUnchangedFrom(oldField);
        }
        if (newField == null) {
            return oldField == null;
        }
        return newField.equals(oldField);
    }

    public SyncViewChangeLog getUpdatesFrom(SyncViewChangeLog old, boolean useUnchanged) {
        if (this.data.getId() != old.getRecordData().getId()) {
            throw new IllegalArgumentException();
        }
        if (old == null || !this.getOp().equals((Object)Operation.UPDATE)) {
            return this;
        }
        int numFields = this.data.getNumFields();
        if (old.getRecordData().getNumFields() != numFields) {
            throw new IllegalArgumentException();
        }
        ViewRecordData oldData = old.getRecordData();
        Object[] fields = new Object[numFields];
        ProblemReasonEnum[] problems = new ProblemReasonEnum[numFields];
        if (this.data.revertAll()) {
            useUnchanged = false;
        }
        boolean changed = false;
        for (int i = 0; i < oldData.getNumFields(); ++i) {
            Object oldField = oldData.getFieldValue(i);
            Object newField = this.data.getFieldValue(i);
            if (useUnchanged && this.isUnchangedFrom(newField, oldField)) {
                fields[i] = SpecialFieldValue.UNCHANGED;
            } else {
                fields[i] = newField;
                changed = true;
            }
            ProblemReasonEnum oldProblem = oldData.getProblems()[i];
            ProblemReasonEnum newProblem = this.data.getProblems()[i];
            if (newProblem == null) {
                if (oldProblem == null) {
                    problems[i] = null;
                    continue;
                }
                problems[i] = newProblem;
                changed = true;
                continue;
            }
            if (newProblem.equals((Object)oldProblem)) {
                problems[i] = null;
                continue;
            }
            problems[i] = newProblem;
            changed = true;
        }
        if (changed) {
            ViewRecordData diffData = new ViewRecordData(this.data.getId(), fields, problems, this.data.isBoundToModel());
            return new SyncViewChangeLog(Operation.UPDATE, diffData);
        }
        return null;
    }

    public static enum Operation {
        DELETE,
        INSERT,
        UPDATE;

    }
}

