/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trinity.api;

import com.ibm.trinity.api.SpecialFieldValue;
import java.io.Serializable;

public abstract class RecordData
implements Serializable {
    private static final long serialVersionUID = -8407458214065597047L;
    private int id;
    private Object[] fields;

    protected RecordData(int id, Object[] fields) {
        this.id = id;
        this.fields = fields;
    }

    public int getId() {
        return this.id;
    }

    public int getNumFields() {
        return this.fields.length;
    }

    public Object getFieldValue(int idx) {
        return this.fields[idx];
    }

    public Object[] getFields() {
        return this.fields;
    }

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append('(');
        sb.append(Integer.toString(this.id));
        sb.append(')');
        if (this.fields != null) {
            sb.append('[');
            for (int i = 0; i < this.fields.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.fields[i]);
            }
            sb.append(']');
        }
        return sb.toString();
    }

    public boolean hasFields(Object[] values) {
        boolean ans = true;
        if (this.fields.length != values.length) {
            ans = false;
        }
        for (int i = 0; i < this.fields.length; ++i) {
            if (this.fields[i] == values[i]) continue;
            ans = false;
        }
        return ans;
    }

    void replaceWritebackFieldValues() {
        for (int i = 0; i < this.fields.length; ++i) {
            Object o = this.fields[i];
            if (o == SpecialFieldValue.EMPTY_WRITEBACK) {
                this.fields[i] = SpecialFieldValue.EMPTY;
                continue;
            }
            if (o != SpecialFieldValue.VOID_WRITEBACK) continue;
            this.fields[i] = SpecialFieldValue.VOID;
        }
    }

    protected void updateFields(Object[] fields) {
        this.fields = fields;
    }
}

