/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trinity.api;

import java.util.LinkedList;
import java.util.List;

public enum ProblemReasonEnum {
    NO_PROBLEM,
    DUPLICATE_KEY,
    INVALID_KEY,
    INVALID_VALUE,
    UNCHANGEABLE,
    UNRESOLVABLE_REFERENCE,
    UNACCEPTABLE_SIMULTANEOUS_UPDATES,
    UNABLE_TO_LOCK(Revert.ALL);

    private final String label;
    private List<String> metaData = new LinkedList<String>();
    public int index = 0;
    private final Revert revert;

    public String getLabel() {
        return this.label;
    }

    public void addMetaData(String name) {
        this.metaData.add(name);
    }

    public void clear() {
        this.index = 0;
        this.metaData.clear();
    }

    public String getMetaData() {
        if (this.metaData.isEmpty()) {
            return "";
        }
        String name = " " + this.metaData.get(this.index);
        this.index = (this.index + 1) % this.metaData.size();
        return name;
    }

    public Revert getRevert() {
        return this.revert;
    }

    private ProblemReasonEnum() {
        this(Revert.KEEP);
    }

    private ProblemReasonEnum(Revert revert) {
        this.label = "ProblemReason." + this.name();
        this.revert = revert;
    }

    public static enum Revert {
        KEEP,
        FIELD,
        ALL;

    }
}

