/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.la.delegates;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.core.data.capellacommon.CapabilityRealizationInvolvedElement;
import org.polarsys.capella.core.data.capellacore.Feature;
import org.polarsys.capella.core.data.capellacore.Type;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.ctx.SystemComponent;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.helpers.capellacommon.delegates.CapabilityRealizationInvolvedElementHelper;
import org.polarsys.capella.core.data.helpers.cs.delegates.ComponentHelper;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.la.LogicalFunction;
import org.polarsys.capella.core.data.pa.PhysicalComponent;

public class LogicalComponentHelper {
    private static LogicalComponentHelper instance;

    private LogicalComponentHelper() {
    }

    public static LogicalComponentHelper getInstance() {
        if (instance == null) {
            instance = new LogicalComponentHelper();
        }
        return instance;
    }

    public Object doSwitch(LogicalComponent element, EStructuralFeature feature) {
        List<SystemComponent> ret = null;
        if (feature.equals(LaPackage.Literals.LOGICAL_COMPONENT__SUB_LOGICAL_COMPONENTS)) {
            ret = this.getSubLogicalComponents(element);
        } else if (feature.equals(LaPackage.Literals.LOGICAL_COMPONENT__ALLOCATED_LOGICAL_FUNCTIONS)) {
            ret = this.getAllocatedLogicalFunctions(element);
        } else if (feature.equals(LaPackage.Literals.LOGICAL_COMPONENT__REALIZING_PHYSICAL_COMPONENTS)) {
            ret = this.getRealizingPhysicalComponents(element);
        } else if (feature.equals(LaPackage.Literals.LOGICAL_COMPONENT__REALIZED_SYSTEM_COMPONENTS)) {
            ret = this.getRealizedSystemComponents(element);
        }
        if (ret == null) {
            ret = ComponentHelper.getInstance().doSwitch((Component)element, feature);
        }
        if (ret == null) {
            ret = CapabilityRealizationInvolvedElementHelper.getInstance().doSwitch((CapabilityRealizationInvolvedElement)element, feature);
        }
        return ret;
    }

    protected List<LogicalComponent> getSubLogicalComponents(LogicalComponent element) {
        ArrayList<LogicalComponent> ret = new ArrayList<LogicalComponent>();
        for (Feature feature : element.getOwnedFeatures()) {
            Type type;
            if (!(feature instanceof Part) || !((type = ((Part)feature).getType()) instanceof LogicalComponent)) continue;
            ret.add((LogicalComponent)type);
        }
        return ret;
    }

    protected List<LogicalFunction> getAllocatedLogicalFunctions(LogicalComponent element) {
        ArrayList<LogicalFunction> ret = new ArrayList<LogicalFunction>();
        for (AbstractFunction function : element.getAllocatedFunctions()) {
            if (!(function instanceof LogicalFunction)) continue;
            ret.add((LogicalFunction)function);
        }
        return ret;
    }

    protected List<PhysicalComponent> getRealizingPhysicalComponents(LogicalComponent element) {
        return element.getRealizingComponents().stream().filter(PhysicalComponent.class::isInstance).map(PhysicalComponent.class::cast).collect(Collectors.toList());
    }

    protected List<SystemComponent> getRealizedSystemComponents(LogicalComponent element) {
        return element.getRealizedComponents().stream().filter(SystemComponent.class::isInstance).map(SystemComponent.class::cast).collect(Collectors.toList());
    }
}

