/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.cs.delegates;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.core.data.capellacore.InvolvedElement;
import org.polarsys.capella.core.data.capellacore.Involvement;
import org.polarsys.capella.core.data.capellacore.InvolverElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.ctx.CapabilityInvolvement;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.ctx.Mission;
import org.polarsys.capella.core.data.ctx.MissionInvolvement;
import org.polarsys.capella.core.data.ctx.SystemComponent;
import org.polarsys.capella.core.data.ctx.SystemFunction;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.helpers.capellacore.delegates.InvolvedElementHelper;
import org.polarsys.capella.core.data.helpers.cs.delegates.ComponentHelper;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.oa.Entity;

public class SystemComponentHelper {
    private static SystemComponentHelper instance;

    private SystemComponentHelper() {
    }

    public static SystemComponentHelper getInstance() {
        if (instance == null) {
            instance = new SystemComponentHelper();
        }
        return instance;
    }

    public Object doSwitch(SystemComponent element, EStructuralFeature feature) {
        List<Mission> ret = null;
        if (feature.equals(CtxPackage.Literals.SYSTEM_COMPONENT__CAPABILITY_INVOLVEMENTS)) {
            ret = this.getCapabilityInvolvements(element);
        } else if (feature.equals(CtxPackage.Literals.SYSTEM_COMPONENT__INVOLVING_CAPABILITIES)) {
            ret = this.getInvolvingCapabilities(element);
        } else if (feature.equals(CtxPackage.Literals.SYSTEM_COMPONENT__MISSION_INVOLVEMENTS)) {
            ret = this.getMissionInvolvements(element);
        } else if (feature.equals(CtxPackage.Literals.SYSTEM_COMPONENT__INVOLVING_MISSIONS)) {
            ret = this.getInvolvingMissions(element);
        } else if (feature.equals(CtxPackage.Literals.SYSTEM_COMPONENT__REALIZED_ENTITIES)) {
            ret = this.getRealizedEntities(element);
        } else if (feature.equals(CtxPackage.Literals.SYSTEM_COMPONENT__REALIZING_LOGICAL_COMPONENTS)) {
            ret = this.getRealizingLogicalComponents(element);
        } else if (feature.equals(CtxPackage.Literals.SYSTEM_COMPONENT__ALLOCATED_SYSTEM_FUNCTIONS)) {
            ret = this.getAllocatedSystemFunctions(element);
        }
        if (ret == null) {
            ret = ComponentHelper.getInstance().doSwitch((Component)element, feature);
        }
        if (ret == null) {
            ret = InvolvedElementHelper.getInstance().doSwitch((InvolvedElement)element, feature);
        }
        return ret;
    }

    protected List<CapabilityInvolvement> getCapabilityInvolvements(SystemComponent element) {
        ArrayList<CapabilityInvolvement> ret = new ArrayList<CapabilityInvolvement>();
        for (Involvement involvement : element.getInvolvingInvolvements()) {
            if (!(involvement instanceof CapabilityInvolvement)) continue;
            ret.add((CapabilityInvolvement)involvement);
        }
        return ret;
    }

    protected List<Capability> getInvolvingCapabilities(SystemComponent element) {
        ArrayList<Capability> ret = new ArrayList<Capability>();
        for (CapabilityInvolvement involvement : element.getCapabilityInvolvements()) {
            InvolverElement involver = involvement.getInvolver();
            if (!(involver instanceof Capability)) continue;
            ret.add((Capability)involver);
        }
        return ret;
    }

    protected List<MissionInvolvement> getMissionInvolvements(SystemComponent element) {
        ArrayList<MissionInvolvement> ret = new ArrayList<MissionInvolvement>();
        for (Involvement involvement : element.getInvolvingInvolvements()) {
            if (!(involvement instanceof MissionInvolvement)) continue;
            ret.add((MissionInvolvement)involvement);
        }
        return ret;
    }

    protected List<Mission> getInvolvingMissions(SystemComponent element) {
        ArrayList<Mission> ret = new ArrayList<Mission>();
        for (MissionInvolvement involvement : element.getMissionInvolvements()) {
            InvolverElement involver = involvement.getInvolver();
            if (!(involver instanceof Mission)) continue;
            ret.add((Mission)involver);
        }
        return ret;
    }

    protected List<Entity> getRealizedEntities(SystemComponent element) {
        return element.getRealizedComponents().stream().filter(Entity.class::isInstance).map(Entity.class::cast).collect(Collectors.toList());
    }

    protected List<LogicalComponent> getRealizingLogicalComponents(SystemComponent element) {
        return element.getRealizingComponents().stream().filter(LogicalComponent.class::isInstance).map(LogicalComponent.class::cast).collect(Collectors.toList());
    }

    protected List<SystemFunction> getAllocatedSystemFunctions(SystemComponent element) {
        ArrayList<SystemFunction> ret = new ArrayList<SystemFunction>();
        for (AbstractFunction function : element.getAllocatedFunctions()) {
            if (!(function instanceof SystemFunction)) continue;
            ret.add((SystemFunction)function);
        }
        return ret;
    }
}

