/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.cs.delegates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.helpers.modellingcore.delegates.InformationsExchangerHelper;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.InformationsExchanger;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.cs.AbstractPhysicalArtifact;
import org.polarsys.capella.core.data.cs.AbstractPhysicalLinkEnd;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.PhysicalPort;
import org.polarsys.capella.core.data.cs.PhysicalPortRealization;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.fa.ComponentPortAllocation;
import org.polarsys.capella.core.data.helpers.cs.delegates.AbstractPhysicalArtifactHelper;
import org.polarsys.capella.core.data.helpers.cs.delegates.AbstractPhysicalLinkEndHelper;
import org.polarsys.capella.core.data.helpers.information.delegates.PortHelper;
import org.polarsys.capella.core.data.information.Port;

public class PhysicalPortHelper {
    private static PhysicalPortHelper instance;

    private PhysicalPortHelper() {
    }

    public static PhysicalPortHelper getInstance() {
        if (instance == null) {
            instance = new PhysicalPortHelper();
        }
        return instance;
    }

    public Object doSwitch(PhysicalPort element, EStructuralFeature feature) {
        Object ret = null;
        if (feature.equals(CsPackage.Literals.PHYSICAL_PORT__ALLOCATED_COMPONENT_PORTS)) {
            ret = this.getAllocatedComponentPorts(element);
        } else if (feature.equals(CsPackage.Literals.PHYSICAL_PORT__REALIZED_PHYSICAL_PORTS)) {
            ret = this.getRealizedPhysicalPorts(element);
        } else if (feature.equals(CsPackage.Literals.PHYSICAL_PORT__REALIZING_PHYSICAL_PORTS)) {
            ret = this.getRealizingPhysicalPorts(element);
        }
        if (ret == null) {
            ret = AbstractPhysicalArtifactHelper.getInstance().doSwitch((AbstractPhysicalArtifact)element, feature);
        }
        if (ret == null) {
            ret = AbstractPhysicalLinkEndHelper.getInstance().doSwitch((AbstractPhysicalLinkEnd)element, feature);
        }
        if (ret == null) {
            ret = InformationsExchangerHelper.getInstance().doSwitch((InformationsExchanger)element, feature);
        }
        if (ret == null) {
            ret = PortHelper.getInstance().doSwitch((Port)element, feature);
        }
        return ret;
    }

    protected List<ComponentPort> getAllocatedComponentPorts(PhysicalPort element) {
        ArrayList<ComponentPort> result = new ArrayList<ComponentPort>();
        for (AbstractTrace trace : element.getOutgoingTraces()) {
            Port port;
            if (!(trace instanceof ComponentPortAllocation) || !((port = ((ComponentPortAllocation)trace).getAllocatedPort()) instanceof ComponentPort)) continue;
            result.add((ComponentPort)port);
        }
        return result;
    }

    protected List<PhysicalPort> getRealizedPhysicalPorts(PhysicalPort element) {
        ArrayList<PhysicalPort> ports = new ArrayList<PhysicalPort>();
        for (AbstractTrace trace : element.getOutgoingTraces()) {
            TraceableElement port;
            if (!(trace instanceof PhysicalPortRealization) || !((port = ((PhysicalPortRealization)trace).getTargetElement()) instanceof PhysicalPort)) continue;
            ports.add((PhysicalPort)port);
        }
        return ports;
    }

    protected List<PhysicalPort> getRealizingPhysicalPorts(PhysicalPort element) {
        ArrayList<PhysicalPort> ports = new ArrayList<PhysicalPort>();
        for (AbstractTrace trace : element.getIncomingTraces()) {
            TraceableElement port;
            if (!(trace instanceof PhysicalPortRealization) || !((port = ((PhysicalPortRealization)trace).getSourceElement()) instanceof PhysicalPort)) continue;
            ports.add((PhysicalPort)port);
        }
        return ports;
    }
}

