#include "bmi_exported.h"
#include "bmi_mesgerr.h"
#include "bmi_indices.h"
#if ! defined (BMI_FLAT_DIR)
#    include "exported/bmi_tail.h"
#else
#    include "bmi_tail.h"
#endif


/*
 * EXPORTED
 * Tail (polynomial, differential ring)
 * Tail (list(polynomial) | regchain, fullset, 
 * 					derivative, differential ring)
 *
 * By convention, if derivative = 0 then the lcoeff is taken w.r.t. 
 * the leading derivative.
 *
 * The Tail function corresponds to the BLAD reductum function.
 */

ALGEB bmi_tail (struct bmi_callback* callback)
{   struct bad_regchain C;
    struct bap_tableof_polynom_mpq polys, Tq;
    struct bap_tableof_polynom_mpz Tz;
    bav_variable v;
    ba0_int_p i;
    bool fullset;
    char *derivative, *buffer;

    if (bmi_nops (callback) != 4)
        BA0_RAISE_EXCEPTION (BMI_ERRNOPS);
    if (! bmi_is_table_op (4, callback))
        BA0_RAISE_EXCEPTION (BMI_ERRDRNG);

    if (bmi_is_regchain_op (1, callback))
        bmi_set_ordering_and_regchain (&C, 1, callback, __FILE__, __LINE__);
    else
        bmi_set_ordering (4, callback, __FILE__, __LINE__);

    derivative = bmi_string_op (3, callback);
    if (! isdigit ((int)derivative [0]))
	ba0_sscanf2 (derivative, "%v", &v);

    if (bmi_is_table_op (1, callback))
    {   fullset = bmi_bool_op (2, callback);
        if (! fullset)
	    bad_remove_zero_derivatives_of_tableof_parameter_from_regchain 
						(&C, &C, &bav_parameters);
	ba0_init_table ((ba0_table)&Tz);
        ba0_realloc2_table ((ba0_table)&Tz, C.decision_system.size,
				(ba0_new_function*)&bap_new_polynom_mpz);
	if (isdigit ((int)derivative [0]))
	{   for (i = 0; i < C.decision_system.size; i++)
		bap_reductum_polynom_mpz (Tz.tab [Tz.size++],
						C.decision_system.tab [i]);
	} else
	{   for (i = 0; i < C.decision_system.size; i++)
		bap_lcoeff_and_reductum_polynom_mpz 
			((bap_polynom_mpz)0, Tz.tab [Tz.size++], 
			 C.decision_system.tab [i], v);
	}
	bav_set_settings_symbol (0, &bav_printf_numbered_symbol);
	buffer = ba0_new_printf ("%t[%Az]", &Tz);
    } else
    {	ba0_init_table ((ba0_table)&polys);
	ba0_init_table ((ba0_table)&Tq);
	ba0_sscanf2 (bmi_string_op (1, callback), 
					"%t[%careful_expanded_Aq]", &polys);
	ba0_realloc2_table ((ba0_table)&Tq, polys.size,
				(ba0_new_function*)&bap_new_polynom_mpq);
	if (isdigit ((int)derivative [0]))
	{   for (i = 0; i < polys.size; i++)
		bap_reductum_polynom_mpq (Tq.tab [Tq.size++], polys.tab [i]);
	} else
	{   for (i = 0; i < polys.size; i++)
		bap_lcoeff_and_reductum_polynom_mpq
		    ((bap_polynom_mpq)0, Tq.tab [Tq.size++], polys.tab [i], v);
	}
	bav_set_settings_symbol (0, &bav_printf_numbered_symbol);
	buffer = ba0_new_printf ("%t[%Aq]", &Tq);
    }

    {   ALGEB res;
	bmi_push_maple_gmp_allocators ();
        res = EvalMapleStatement (callback->kv, buffer);
	bmi_pull_maple_gmp_allocators ();
        return res;
    }
}
