#include "bmi_exported.h"
#include "bmi_mesgerr.h"
#include "bmi_indices.h"
#if ! defined (BMI_FLAT_DIR)
#    include "exported/bmi_sort_by_rank.h"
#else
#    include "bmi_sort_by_rank.h"
#endif


/*************************************************************
 * SORT
 *************************************************************/

static int bmi_compar_ascending_rank (const void* AA, const void* BB)
{   bap_polynom_mpq A = *(bap_polynom_mpq*)AA;
    bap_polynom_mpq B = *(bap_polynom_mpq*)BB;

    if (bap_gt_rank_polynom_mpq (A, B))
	return 1;
    else if (bap_equal_rank_polynom_mpq (A, B))
	return 0;
    else
	return -1;
}

static int bmi_compar_descending_rank (const void* AA, const void* BB)
{   bap_polynom_mpq A = *(bap_polynom_mpq*)AA;
    bap_polynom_mpq B = *(bap_polynom_mpq*)BB;

    if (bap_gt_rank_polynom_mpq (A, B))
	return -1;
    else if (bap_equal_rank_polynom_mpq (A, B))
	return 0;
    else
	return 1;
}

/*
 * EXPORTED
 *
 * Sort (list(polynomial), ascending | descending, differential ring)
 */

ALGEB bmi_sort_by_rank (struct bmi_callback* callback)
{   struct bap_tableof_polynom_mpq T;
    char *eqns, *ord;
    int (*f) (const void*, const void*);

    if (bmi_nops (callback) != 3)
	BA0_RAISE_EXCEPTION (BMI_ERRNOPS);
    if (! bmi_is_table_op (3, callback))
	BA0_RAISE_EXCEPTION (BMI_ERRDRNG);

    bmi_set_ordering (3, callback, __FILE__, __LINE__);

    eqns = bmi_string_op (1, callback);
    ord = bmi_string_op (2, callback);

    ba0_init_table ((ba0_table)&T);
    ba0_sscanf2 (eqns, "%t[%careful_expanded_Aq]", &T);

    if (strcmp (ord, BMI_IX_ascending) == 0)
	f = &bmi_compar_ascending_rank;
    else
	f = &bmi_compar_descending_rank;

    qsort (T.tab, (size_t)T.size, sizeof (bap_polynom_mpq), f);

    {   char* stres;
	ALGEB res;
	bav_set_settings_symbol (0, &bav_printf_numbered_symbol);
	stres = ba0_new_printf ("%t[%Aq]", &T);
	bmi_push_maple_gmp_allocators ();
        res = EvalMapleStatement (callback->kv, stres);
	bmi_pull_maple_gmp_allocators ();
        return res;
    }
}

