#include "bmi_exported.h"
#include "bmi_mesgerr.h"
#include "bmi_indices.h"
#if ! defined (BMI_FLAT_DIR)
#    include "exported/bmi_preparation_equation.h"
#else
#    include "bmi_preparation_equation.h"
#endif

static void bmi_check_zstring (char*);

/*
 * EXPORTED
 *
 * PreparationEquation (polynomial, regchain, n, congruence, zstring)
 */

ALGEB bmi_preparation_equation (struct bmi_callback* callback)
{   struct bad_preparation_equation E;
    struct bad_regchain A;
    struct bap_polynom_mpq F;
    struct bap_polynom_mpz numF;
    bap_polynom_mpz ddz;
    ba0_mpz_t denF;
    ba0_int_p n;
    bool congruence;
    char *zstring, *nb, *buffer;

    if (bmi_nops (callback) != 5)
	BA0_RAISE_EXCEPTION (BMI_ERRNOPS);
    if (! bmi_is_regchain_op (2, callback))
	BA0_RAISE_EXCEPTION (BMI_ERRREGC);

    bmi_set_ordering_and_regchain (&A, 2, callback, __FILE__, __LINE__);
/*
 * F is decomposed as numerator / denominator
 */
    bap_init_polynom_mpq (&F);
    ba0_sscanf2 (bmi_string_op (1, callback), "%careful_expanded_Aq", &F);
    bap_init_polynom_mpz (&numF);
    mpz_init (denF);
    bap_numer_polynom_mpq (&numF, denF, &F);
/*
 * The number of equations which should be considered as base field equations
 */
    nb = bmi_string_op (3, callback);
    n = atoi (nb);
/*
 * The congruence
 */
    congruence = bmi_bool_op (4, callback);
/*
 * The string used for printing the zi
 */
    zstring = bmi_string_op (5, callback);
    bmi_check_zstring (zstring);
    bad_set_settings_preparation (zstring);
/*
 * Compute the equation
 */
    bad_init_preparation_equation (&E);
    bad_set_preparation_equation_polynom (&E, &numF, denF, &A, n, &ddz);
/*
 * Strip it if only the congruence is needed.
 */
    if (congruence)
    {	bav_Idegree q;
	ba0_int_p l;

	bad_preparation_congruence (&l, &q, &E);
	E.terms.size = l;
	E.coeffs.size = l;
    }
/*
 * The result
 */
    bav_set_settings_symbol (0, &bav_printf_numbered_symbol);
    buffer = ba0_new_printf ("%preparation_equation", &E);

    {   ALGEB res;
	bmi_push_maple_gmp_allocators ();
	res = EvalMapleStatement (callback->kv, buffer);
	bmi_pull_maple_gmp_allocators ();
	return res;
    }
}

/*
 * Calls ba0_get_format in order to perform the basic format checking
 * Then makes sure that there is only one special format code, which is "%d"
 */

static void bmi_check_zstring (char* zstring)
{   ba0_format f;
    ba0_int_p i;

    f = ba0_get_format (zstring);
    i = 0;
    while (zstring [i] && zstring [i] != '%')
        i += 1;
    if (zstring [i] != '%' || zstring [i+1] != 'd')
        BA0_RAISE_EXCEPTION (BMI_ERRZSTR);
    i += 2;
    while (zstring [i] && zstring [i] != '%')
        i += 1;
    if (zstring [i])
        BA0_RAISE_EXCEPTION (BMI_ERRZSTR);
}

