#include "bmi_exported.h"
#include "bmi_mesgerr.h"
#include "bmi_indices.h"
#if ! defined (BMI_FLAT_DIR)
#    include "exported/bmi_pardi.h"
#else
#    include "bmi_pardi.h"
#endif


/*
 * EXPORTED
 * Pardi (regchain, differential ring, prime)
 */

ALGEB bmi_pardi (struct bmi_callback* callback)
{   struct bad_regchain C, Cbar;
    bav_Iordering r, rbar;
    struct ba0_tableof_string properties;
    struct ba0_exception_code code;
    struct ba0_mark M;
    char *bar_ordering;
    bool prime;

    if (bmi_nops (callback) != 3)
        BA0_RAISE_EXCEPTION (BMI_ERRNOPS);
    if (! bmi_is_regchain_op (1, callback))
	BA0_RAISE_EXCEPTION (BMI_ERRREGC);
/*
 * The input regchain and its ordering
 */
    r = bmi_set_ordering_and_regchain (&C, 1, callback, __FILE__, __LINE__);
/*
 * The target ordering.
 * An exception may be raised while parsing it.
 * It is reformulated in BMI_ERRPRNK.
 */

    bar_ordering = bmi_string_op (2, callback);
    BA0_PUSH_EXCEPTION (code);
    if (ba0_exception_is_set (code)) 
    {	ba0_sscanf2 (bar_ordering, "%ordering", &rbar);
	ba0_pull_exception (code);
    } else
    {	
	if (ba0_mesgerr == BA0_ERROOM || ba0_mesgerr == BA0_ERRALR)
	    BA0_RAISE_EXCEPTION (ba0_mesgerr);
	BA0_RAISE_EXCEPTION (BMI_ERRPRNK);
    }
/*
 * The primality issue.
 * The chain may have the prime attribute, may be obviously prime or may
 * be assumed to be prime. Otherwise, exception BMI_ERRPARD is raised.
 *
 * The resulting chain will have the prime attribute.
 */
    prime = bmi_bool_op (3, callback);
    if (! prime && 
	! bad_has_structural_property_attchain
				(&C.attrib, bad_prime_structural_property) &&
	! bad_is_explicit_regchain (&C))
	BA0_RAISE_EXCEPTION (BMI_ERRPARD);
    bad_set_structural_property_attchain 
				(&C.attrib, bad_prime_structural_property);

    ba0_init_table ((ba0_table)&properties);
    bad_structural_properties_attchain (&properties, &C.attrib);
    bad_desired_properties_attchain (&properties, &C.attrib);
/*
 * Call to PARDI
 */
    bad_set_settings_reduction (0, bad_probabilistic_redzero_strategy, 0);

    ba0_record (&M);
    bad_init_regchain (&Cbar);
    bad_set_properties_regchain (&Cbar, &properties);
    bad_pardi (&Cbar, rbar, &C);

/*
    bad_printf_stats (0);
    ba0_printf ("\n");
    ba0_restore (&M);

    bad_init_stats (0);
    bad_stats_data.easy_criterion_on = false;
    bad_init_regchain (&Cbar);
    bad_set_properties_regchain (&Cbar, &properties);
    bad_pardi (&Cbar, rbar, &C);

    bad_printf_stats (0);
    ba0_printf ("\n");
*/
/*
 * A complete change of ring is performed on the result.
 * Beware to the parameters (bugfix in June 2010).
 * This is done to avoid the growth of the differential ring in some scenarii.
 */
    {   
        struct bad_regchain Chat;
        bav_Iordering rhat;
	char* bar_parameters;
	char* bar_C;
        ALGEB res;

	bar_parameters = ba0_new_printf ("%t[%param]", &bav_parameters);
	bar_C = ba0_new_printf ("%regchain", &Cbar);
	
        bav_init_differential_ring (&bav_R);
	bav_init_parameters (&bav_parameters);

        ba0_sscanf2 (bar_ordering, "%ordering", &rhat);
        bav_R_push_ordering (rhat);
	ba0_sscanf2 (bar_parameters, "%t[%param]", &bav_parameters);

        bad_init_regchain (&Chat);
        ba0_sscanf2 (bar_C, "%pretend_regchain", &Chat);

	res = bmi_rtable_regchain (callback->kv, &Chat, __FILE__, __LINE__);
        return res;
    }
}

