#include "bmi_exported.h"
#include "bmi_mesgerr.h"
#include "bmi_indices.h"
#if ! defined (BMI_FLAT_DIR)
#    include "exported/bmi_leading_derivative.h"
#else
#    include "bmi_leading_derivative.h"
#endif


/*
 * EXPORTED
 * LeadingDerivative (list(polynomial) | regchain, fullset, differential ring)
 */

ALGEB bmi_leading_derivative (struct bmi_callback* callback)
{   struct bad_regchain C;
    struct bap_tableof_polynom_mpq polys;
    struct bav_tableof_variable T;
    ba0_int_p i;
    bool fullset;

    if (bmi_nops (callback) != 3)
	BA0_RAISE_EXCEPTION (BMI_ERRNOPS);
    if (! bmi_is_table_op (3, callback))
	BA0_RAISE_EXCEPTION (BMI_ERRDRNG);

    if (bmi_is_regchain_op (1, callback))
        bmi_set_ordering_and_regchain (&C, 1, callback, __FILE__, __LINE__);
    else
        bmi_set_ordering (3, callback, __FILE__, __LINE__);

    ba0_init_table ((ba0_table)&T);

    if (bmi_is_table_op (1, callback))
    {	fullset = bmi_bool_op (2, callback);
	if (! fullset)
	    bad_remove_zero_derivatives_of_tableof_parameter_from_regchain
						(&C, &C, &bav_parameters);
	ba0_realloc_table ((ba0_table)&T, C.decision_system.size);
	for (i = 0; i < C.decision_system.size; i++)
	    T.tab [T.size++] = 
			bap_leader_polynom_mpz (C.decision_system.tab [i]);
    } else	
    {	ba0_init_table ((ba0_table)&polys);
	ba0_sscanf2 (bmi_string_op (1, callback), 
				"%t[%careful_expanded_Aq]", &polys);
	ba0_realloc_table ((ba0_table)&T, polys.size);
	for (i = 0; i < polys.size; i++)
	    T.tab [T.size++] = bap_leader_polynom_mpq (polys.tab [i]);
    }

    {   char* stres;
	ALGEB res;
	bav_set_settings_symbol (0, &bav_printf_numbered_symbol);
	stres = ba0_new_printf ("%t[%v]", &T);
	bmi_push_maple_gmp_allocators ();
        res = EvalMapleStatement (callback->kv, stres);
	bmi_pull_maple_gmp_allocators ();
        return res;
    }
}
