#include "bmi_exported.h"
#include "bmi_mesgerr.h"
#include "bmi_indices.h"
#if ! defined (BMI_FLAT_DIR)
#    include "exported/bmi_indets.h"
#else
#    include "bmi_indets.h"
#endif


/*
 * EXPORTED
 *
 * Indets (list(polynomials) | regchain | differential ring, 
 * 		selection, fullset, differential ring | regular chain)
 *     
 *     Applies to the variables occuring in the list of polynomials
 *
 *     If the first op is a differential ring then it is the same as
 *     the last op and the function applies to the ring variables.
 */

ALGEB bmi_indets (struct bmi_callback* callback)
{   struct bad_regchain C;
    struct bap_tableof_ratfrac_mpz T;
    struct bav_tableof_variable U;
    bav_variable v;
    ba0_int_p i;
    bool depvars, indepvars, derivatives, allvars, params;
    bool fullset;
    char *eqns, *selection;

    if (bmi_nops (callback) != 4)
	BA0_RAISE_EXCEPTION (BMI_ERRNOPS);
    if (! bmi_is_table_op (4, callback))
        BA0_RAISE_EXCEPTION (BMI_ERRDRNG);

    if (bmi_is_regchain_op (1, callback))
	bmi_set_ordering_and_regchain (&C, 1, callback, __FILE__, __LINE__);
    else if (bmi_is_regchain_op (4, callback))
	bmi_set_ordering_and_regchain (&C, 4, callback, __FILE__, __LINE__);
    else
        bmi_set_ordering (4, callback, __FILE__, __LINE__);

    selection = bmi_string_op (2, callback);

    if (bmi_is_regchain_op (1, callback))
    {	fullset = bmi_bool_op (3, callback);
	if (! fullset)
	    bad_remove_zero_derivatives_of_tableof_parameter_from_regchain 
						(&C, &C, &bav_parameters);
	bav_R_mark_variables (false);
	for (i = 0; i < C.decision_system.size; i++)
		bap_mark_indets_polynom_mpz (C.decision_system.tab [i]);
    } else if (bmi_is_dring_op (1, callback))
    {   bav_R_mark_variables (true);
    } else
    {   eqns = bmi_string_op (1, callback);
	ba0_init_table ((ba0_table)&T);
	ba0_sscanf2 (eqns, "%t[%careful_expanded_Qz]", &T);
	bav_R_mark_variables (false);
    	for (i = 0; i < T.size; i++)
    	{   bap_mark_indets_polynom_mpz (&T.tab [i]->numer);
	    bap_mark_indets_polynom_mpz (&T.tab [i]->denom);
        }
    }

    depvars = indepvars = derivatives = allvars = params = false;
    if (strcmp (selection, BMI_IX_depvars) == 0)
	depvars = true;
    else if (strcmp (selection, BMI_IX_indepvars) == 0)
	indepvars = true;
    else if (strcmp (selection, BMI_IX_derivs) == 0)
	derivatives = true;
    else if (strcmp (selection, BMI_IX_allvars) == 0)
	allvars = true;
    else if (strcmp (selection, BMI_IX_params) == 0)
	params = true;
    else
	BA0_RAISE_EXCEPTION (BMI_ERRCRIT);

    ba0_init_table ((ba0_table)&U);
    ba0_realloc_table ((ba0_table)&U, bav_R.vars.size);

    for (i = 0; i < bav_R.vars.size; i++)
    {	v = bav_R.vars.tab [i];
	if (v->hack)
	{   if (allvars)
		U.tab [U.size++] = v;
	    else if (derivatives && bav_symbol_type_variable (v) == 
							bav_dependent_symbol)
		U.tab [U.size++] = v;
	    else if (depvars && bav_symbol_type_variable (v) == 
							bav_dependent_symbol)
		U.tab [U.size++] = bav_order_zero_variable (v);
	    else if (params && bav_is_a_parameter 
				(v->root, (ba0_int_p*)0, &bav_parameters))
		U.tab [U.size++] = v;
	    else if (indepvars && bav_symbol_type_variable (v) ==
						bav_independent_symbol)
		U.tab [U.size++] = v;
	}
    }

    {   char* stres;
	ALGEB res;
	bav_set_settings_symbol (0, &bav_printf_numbered_symbol);
	stres = ba0_new_printf ("%t{%v}", &U);
	bmi_push_maple_gmp_allocators ();
        res = EvalMapleStatement (callback->kv, stres);
	bmi_pull_maple_gmp_allocators ();
        return res;
    }
}

