#include "bmi_exported.h"
#include "bmi_mesgerr.h"
#include "bmi_indices.h"
#if ! defined (BMI_FLAT_DIR)
#    include "exported/bmi_differentiate.h"
#else
#    include "bmi_differentiate.h"
#endif


/*
 * Differentiate (list(ratfrac) | regchain, fullset,
 * 				list (derivations), differential ring)
 */

ALGEB bmi_differentiate (struct bmi_callback* callback)
{   struct bad_regchain C;
    struct bap_tableof_ratfrac_mpz U;
    struct bav_tableof_variable nulles;
    struct bav_tableof_term T;
    bav_term term;
    bav_symbol y;
    bav_Idegree d;
    ba0_int_p k, i, j;
    bool fullset;
    char *polys, *lders, *buffer;
    
    if (bmi_nops (callback) != 4)
	BA0_RAISE_EXCEPTION (BMI_ERRNOPS);
    if (! bmi_is_table_op (4, callback))
	BA0_RAISE_EXCEPTION (BMI_ERRDRNG);

    if (bmi_is_regchain_op (1, callback))
	bmi_set_ordering_and_regchain (&C, 1, callback, __FILE__, __LINE__);
    else
	bmi_set_ordering (4, callback, __FILE__, __LINE__);

    ba0_init_table ((ba0_table)&nulles);
    bav_zero_derivatives_of_tableof_parameter (&nulles, &bav_parameters);

    lders = bmi_string_op (3, callback);
    ba0_init_table ((ba0_table)&T);
    ba0_sscanf2 (lders, "%t[%term]", &T);

    if (bmi_is_regchain_op (1, callback))
    {   fullset = bmi_bool_op (2, callback);
	if (! fullset)
	    bad_remove_zero_derivatives_of_tableof_parameter_from_regchain 
						(&C, &C, &bav_parameters);
        for (k = 0; k < C.decision_system.size; k++)
	{   for (i = 0; i < T.size; i++)
	    {	term = T.tab [i];
		for (j = 0; j < term->size; j++)
		{   y = term->rg [j].var->root;
		    for (d = 0; d < term->rg [j].deg; d++)
			bap_diff_polynom_mpz (C.decision_system.tab [k],
					C.decision_system.tab [k], y, &nulles);
		}
	    }
	}
	bav_set_settings_symbol (0, &bav_printf_numbered_symbol);
	buffer = ba0_new_printf ("%t[%Az]", &C.decision_system);
    } else
    {	
	polys = bmi_string_op (1, callback);
	ba0_init_table ((ba0_table)&U);
	ba0_sscanf2 (polys, "%t[%careful_expanded_Qz]", &U);
	for (k = 0; k < U.size; k++)
	{   for (i = 0; i < T.size; i++)
	    {   term = T.tab [i];
                for (j = 0; j < term->size; j++)
                {   y = term->rg [j].var->root;
                    for (d = 0; d < term->rg [j].deg; d++)
			bap_diff_ratfrac_mpz 
					(U.tab [k], U.tab [k], y, &nulles);
		}
	    }
	}
	bav_set_settings_symbol (0, &bav_printf_numbered_symbol);
	buffer = ba0_new_printf ("%t[%careful_expanded_Qz]", &U);
    }

    {   ALGEB res;
	bmi_push_maple_gmp_allocators ();
        res = EvalMapleStatement (callback->kv, buffer);
	bmi_pull_maple_gmp_allocators ();
        return res;
    }
}

