#include "bmi_exported.h"
#include "bmi_mesgerr.h"
#include "bmi_indices.h"
#if ! defined (BMI_FLAT_DIR)
#    include "exported/bmi_delta_polynomial.h"
#else
#    include "bmi_delta_polynomial.h"
#endif

/*
 * EXPORTED
 * DeltaPolynomial (p, q, dring)
 */

ALGEB bmi_delta_polynomial (struct bmi_callback* callback)
{   struct bad_regchain C;
    struct bad_critical_pair pair;
    struct bav_tableof_variable nulles;
    struct bap_polynom_mpq P, Q;
    struct bap_polynom_mpz numP, numQ, delta;
    char *p, *q;

    if (bmi_nops (callback) != 3)
        BA0_RAISE_EXCEPTION (BMI_ERRNOPS);
    if (! bmi_is_table_op (3, callback))
        BA0_RAISE_EXCEPTION (BMI_ERRREGC);

    if (bmi_is_regchain_op (3, callback))
        bmi_set_ordering_and_regchain (&C, 3, callback, __FILE__, __LINE__);
    else
        bmi_set_ordering (3, callback, __FILE__, __LINE__);

    p = bmi_string_op (1, callback);
    q = bmi_string_op (2, callback);

    bap_init_polynom_mpq (&P);
    bap_init_polynom_mpq (&Q);
    ba0_sscanf2 (p, "%careful_expanded_Aq", &P);
    ba0_sscanf2 (q, "%careful_expanded_Aq", &Q);

    bap_init_polynom_mpz (&numP);
    bap_init_polynom_mpz (&numQ);
    bap_numer_polynom_mpq (&numP, 0, &P);
    bap_numer_polynom_mpq (&numQ, 0, &Q);

    bad_init_critical_pair (&pair);
    bad_set_critical_pair_polynom_mpz (&pair, &numP, &numQ);

    ba0_init_table ((ba0_table)&nulles);
    bav_zero_derivatives_of_tableof_parameter (&nulles, &bav_parameters);

    bap_init_polynom_mpz (&delta);
    bad_delta_polynom_critical_pair (&delta, &pair, &nulles);
    if (! bap_is_zero_polynom_mpz (&delta))
	bap_normal_numeric_primpart_polynom_mpz (&delta, &delta);

    {   ALGEB res;
	char* stres;
	bav_set_settings_symbol (0, &bav_printf_numbered_symbol);
	stres = ba0_new_printf ("%Az", &delta);
	bmi_push_maple_gmp_allocators ();
	res = EvalMapleStatement (callback->kv, stres);
	bmi_pull_maple_gmp_allocators ();
        return res;
    }
}

