#include "bmi_exported.h"
#include "bmi_mesgerr.h"
#include "bmi_indices.h"
#if ! defined (BMI_FLAT_DIR)
#    include "exported/bmi_coeffs.h"
#else
#    include "bmi_coeffs.h"
#endif


static ALGEB bmi_coeffs_larger 
	(bap_ratfrac_mpz (A), bav_variable v, struct bmi_callback* callback)
{   struct bap_tableof_ratfrac_mpz terms;
    struct bap_tableof_polynom_mpq coeffs;
    struct bap_itercoeff_mpz iter;
    struct bap_ratfrac_mpz B;
    struct bap_polynom_mpz C;
    struct bav_term T;
    mpq_t icontent;

    mpq_init (icontent);
    bap_signed_numeric_content_polynom_mpz 
    				(mpq_numref (icontent), &A->numer);
    bap_normal_numeric_primpart_polynom_mpz (&A->numer, &A->numer);

    bap_init_ratfrac_mpz (&B);
    bap_signed_numeric_content_polynom_mpz 
    				(mpq_denref (icontent), &A->denom);
    bap_normal_numeric_primpart_polynom_mpz (&B.denom, &A->denom);

    mpq_canonicalize (icontent);
    
    bav_init_term (&T);
    bap_init_readonly_polynom_mpz (&C);

    ba0_init_table ((ba0_table)&terms);
    ba0_init_table ((ba0_table)&coeffs);

    bap_begin_itercoeff_mpz (&iter, &A->numer, v);
    while (! bap_outof_itercoeff_mpz (&iter))
    {	if (terms.size == terms.alloc)
	{   ba0_realloc2_table ((ba0_table)&terms, 2*terms.size + 1,
				(ba0_new_function*)&bap_new_ratfrac_mpz);
	    ba0_realloc2_table ((ba0_table)&coeffs, 2*terms.size + 1,
				(ba0_new_function*)&bap_new_polynom_mpq);
        }
	bap_term_itercoeff_mpz (&T, &iter);
	bap_set_polynom_term_mpz (&B.numer, &T);
	bap_reduce_ratfrac_mpz (terms.tab [terms.size], &B);
	bap_coeff_itercoeff_mpz (&C, &iter);
	bap_polynom_mpz_to_mpq (coeffs.tab [coeffs.size], &C);
	bap_mul_polynom_numeric_mpq 
		(coeffs.tab [coeffs.size], coeffs.tab [coeffs.size], icontent);
	terms.size += 1;
	coeffs.size += 1;
	bap_next_itercoeff_mpz (&iter);
    }
    bap_close_itercoeff_mpz (&iter);

/*
fprintf (stderr, "larger: %s\n", (char*)res);
*/
    {   char *stres;
	ALGEB res;
	bav_set_settings_symbol (0, &bav_printf_numbered_symbol);
	stres = ba0_new_printf ("%t[%Aq], %t[%Qz]", &coeffs, &terms);
	bmi_push_maple_gmp_allocators ();
	res = EvalMapleStatement (callback->kv, stres);
	bmi_pull_maple_gmp_allocators ();
	return res;
    }
}

/*
 * Handles the numerical rational fractions also
 */

static ALGEB bmi_coeffs_lower 
	(bap_ratfrac_mpz A, bav_variable v, struct bmi_callback* callback)
{   struct bav_tableof_term terms;
    struct bap_tableof_ratfrac_mpz coeffs;
    struct bap_itercoeff_mpz iter;
    struct bap_polynom_mpz C;
    mpz_t icnum;

    ba0_init_table ((ba0_table)&terms);
    ba0_init_table ((ba0_table)&coeffs);
/*
 * Skip all computations, which would raise an error, in the case
 * of the zero rational fraction.
 */
    if (bap_is_zero_ratfrac_mpz (A))
	goto fin;

    mpz_init (icnum);
    bap_signed_numeric_content_polynom_mpz (icnum, &A->numer);
    bap_normal_numeric_primpart_polynom_mpz (&A->numer, &A->numer);

    bap_init_readonly_polynom_mpz (&C);

    bap_begin_itercoeff_mpz (&iter, &A->numer, v);
    while (! bap_outof_itercoeff_mpz (&iter))
    {   if (terms.size == terms.alloc)
        {   ba0_realloc2_table ((ba0_table)&terms, 2*terms.size + 1,
                                (ba0_new_function*)&bav_new_term);
            ba0_realloc2_table ((ba0_table)&coeffs, 2*terms.size + 1,
                                (ba0_new_function*)&bap_new_ratfrac_mpz);
        }
        bap_term_itercoeff_mpz (terms.tab [terms.size], &iter);
	bap_coeff_itercoeff_mpz (&C, &iter);
	bap_mul_polynom_numeric_mpz 
				(&coeffs.tab [coeffs.size]->numer, &C, icnum);
	bap_set_polynom_mpz (&coeffs.tab [coeffs.size]->denom, &A->denom);
	bap_reduce_ratfrac_mpz 
			(coeffs.tab [coeffs.size], coeffs.tab [coeffs.size]);
	terms.size += 1;
	coeffs.size += 1;
	bap_next_itercoeff_mpz (&iter);
    }
    bap_close_itercoeff_mpz (&iter);
/*
 * Label just used for the special case of the zero rational fraction
 */
fin:
/*
fprintf (stderr, "lower: %s\n", (char*)res);
*/
    {	char* stres;
	ALGEB res;
	bav_set_settings_symbol (0, &bav_printf_numbered_symbol);
	stres = ba0_new_printf ("%t[%Qz], %t[%term]", &coeffs, &terms);
	bmi_push_maple_gmp_allocators ();
	res = EvalMapleStatement (callback->kv, stres);
	bmi_pull_maple_gmp_allocators ();
	return res;
    }
}

/*
 * EXPORTED
 *
 * Coeffs (ratfrac, variable, differential ring)
 */

ALGEB bmi_coeffs (struct bmi_callback* callback)
{   struct bap_ratfrac_mpz A;
    struct bav_tableof_variable X;
    bav_variable v;
    ba0_int_p i;
    char *ratfrac, *variable;
    bool larger, lower;

    if (bmi_nops (callback) != 3)
	BA0_RAISE_EXCEPTION (BMI_ERRNOPS);
    if (! bmi_is_table_op (3, callback))
	BA0_RAISE_EXCEPTION (BMI_ERRDRNG);
    bmi_set_ordering (3, callback, __FILE__, __LINE__);

    ratfrac = bmi_string_op (1, callback);
    bap_init_ratfrac_mpz (&A);
    ba0_sscanf2 (ratfrac, "%careful_expanded_Qz", &A);

    variable = bmi_string_op (2, callback);
    ba0_sscanf2 (variable, "%v", &v);

    bav_R_mark_variables (false);
    bap_mark_indets_polynom_mpz (&A.denom);
    ba0_init_table ((ba0_table)&X);
    bav_R_marked_variables (&X, true);
    larger = lower = false;
    for (i = 0; i < X.size; i++)
    {   if (bav_variable_number (X.tab [i]) >= bav_variable_number (v))
            larger = true;
        else
            lower = true;
    }
    if (larger && lower)
        BA0_RAISE_EXCEPTION (BMI_ERRCOEF);

    return larger ? bmi_coeffs_larger (&A, v, callback) : 
				bmi_coeffs_lower (&A, v, callback);
}
