#include "bmi_exported.h"
#include "bmi_mesgerr.h"
#include "bmi_indices.h"

#if defined (_MSC_VER)
#    define BMI_FLAT_DIR
#endif

#if ! defined (BMI_FLAT_DIR)
#    include "exported/bmi_all_derivatives.h"
#else
#    include "bmi_all_derivatives.h"
#endif

#if ! defined (BMI_FLAT_DIR)
#    include "exported/bmi_attributes.h"
#else
#    include "bmi_attributes.h"
#endif

#if ! defined (BMI_FLAT_DIR)
#    include "exported/bmi_base_field_generators.h"
#else
#    include "bmi_base_field_generators.h"
#endif

#if ! defined (BMI_FLAT_DIR)
#    include "exported/bmi_belongs_to.h"
#else
#    include "bmi_belongs_to.h"
#endif

#if ! defined (BMI_FLAT_DIR)
#    include "exported/bmi_coeffs.h"
#else
#    include "bmi_coeffs.h"
#endif

#if ! defined (BMI_FLAT_DIR)
#    include "exported/bmi_delta_polynomial.h"
#else
#    include "bmi_delta_polynomial.h"
#endif

#if ! defined (BMI_FLAT_DIR)
#    include "exported/bmi_differential_prem.h"
#else
#    include "bmi_differential_prem.h"
#endif

#if ! defined (BMI_FLAT_DIR)
#    include "exported/bmi_differential_ring.h"
#else
#    include "bmi_differential_ring.h"
#endif

#if ! defined (BMI_FLAT_DIR)
#    include "exported/bmi_differentiate.h"
#else
#    include "bmi_differentiate.h"
#endif

#if ! defined (BMI_FLAT_DIR)
#    include "exported/bmi_equations.h"
#else
#    include "bmi_equations.h"
#endif

#if ! defined (BMI_FLAT_DIR)
#    include "exported/bmi_factor_derivative.h"
#else
#    include "bmi_factor_derivative.h"
#endif

#if ! defined (BMI_FLAT_DIR)
#    include "exported/bmi_field_element.h"
#else
#    include "bmi_field_element.h"
#endif

#include "bmi_frozen_symbols.h"

#if ! defined (BMI_FLAT_DIR)
#    include "exported/bmi_indets.h"
#else
#    include "bmi_indets.h"
#endif

#if ! defined (BMI_FLAT_DIR)
#    include "exported/bmi_is_orthonomic.h"
#else
#    include "bmi_is_orthonomic.h"
#endif

#if ! defined (BMI_FLAT_DIR)
#    include "exported/bmi_is_reduced.h"
#else
#    include "bmi_is_reduced.h"
#endif

#if ! defined (BMI_FLAT_DIR)
#    include "exported/bmi_leading_coefficient.h"
#else
#    include "bmi_leading_coefficient.h"
#endif

#if ! defined (BMI_FLAT_DIR)
#    include "exported/bmi_leading_derivative.h"
#else
#    include "bmi_leading_derivative.h"
#endif

#if ! defined (BMI_FLAT_DIR)
#    include "exported/bmi_leading_rank.h"
#else
#    include "bmi_leading_rank.h"
#endif

#if ! defined (BMI_FLAT_DIR)
#    include "exported/bmi_min_rank_element.h"
#else
#    include "bmi_min_rank_element.h"
#endif

#if ! defined (BMI_FLAT_DIR)
#    include "exported/bmi_max_rank_element.h"
#else
#    include "bmi_max_rank_element.h"
#endif

#if ! defined (BMI_FLAT_DIR)
#    include "exported/bmi_normal_form.h"
#else
#    include "bmi_normal_form.h"
#endif

#if ! defined (BMI_FLAT_DIR)
#    include "exported/bmi_normal_form_ext.h"
#else
#    include "bmi_normal_form_ext.h"
#endif

#if ! defined (BMI_FLAT_DIR)
#    include "exported/bmi_ranking.h"
#else
#    include "bmi_ranking.h"
#endif

#if ! defined (BMI_FLAT_DIR)
#    include "exported/bmi_parameters.h"
#else
#    include "bmi_parameters.h"
#endif

#if ! defined (BMI_FLAT_DIR)
#    include "exported/bmi_pardi.h"
#else
#    include "bmi_pardi.h"
#endif

#if ! defined (BMI_FLAT_DIR)
#    include "exported/bmi_preparation_equation.h"
#else
#    include "bmi_preparation_equation.h"
#endif

#if ! defined (BMI_FLAT_DIR)
#    include "exported/bmi_pretend_regchain.h"
#else
#    include "bmi_pretend_regchain.h"
#endif

#if ! defined (BMI_FLAT_DIR)
#    include "exported/bmi_process_expansion_point.h"
#else
#    include "bmi_process_expansion_point.h"
#endif

#if ! defined (BMI_FLAT_DIR)
#    include "exported/bmi_reduced_form.h"
#else
#    include "bmi_reduced_form.h"
#endif

#if ! defined (BMI_FLAT_DIR)
#    include "exported/bmi_Rosenfeld_Groebner.h"
#else
#    include "bmi_Rosenfeld_Groebner.h"
#endif

#if ! defined (BMI_FLAT_DIR)
#    include "exported/bmi_separant.h"
#else
#    include "bmi_separant.h"
#endif

#if ! defined (BMI_FLAT_DIR)
#    include "exported/bmi_sort_by_rank.h"
#else
#    include "bmi_sort_by_rank.h"
#endif

#if ! defined (BMI_FLAT_DIR)
#    include "exported/bmi_tail.h"
#else
#    include "bmi_tail.h"
#endif

/**********************************************************************
 * The table of the exported functions and the entry point.
 * It *must* be sorted by alphabetic order.
 **********************************************************************/

struct bmi_exported_pair {
    char* name;
    ALGEB (*pointer) (struct bmi_callback*);
};

static struct bmi_exported_pair bmi_exported_table [] = {
    { "AllDerivatives", &bmi_all_derivatives },
    { "Attributes", &bmi_attributes },
    { "BaseFieldGenerators", &bmi_base_field_generators },
    { "BelongsTo", &bmi_belongs_to },
    { "Coeffs", &bmi_coeffs },
    { "DeltaPolynomial", &bmi_delta_polynomial },
    { "DifferentialPrem", &bmi_differential_prem },
    { "DifferentialRing", &bmi_differential_ring },
    { "Differentiate", &bmi_differentiate },
    { "Equations", &bmi_equations },
    { "EquationsWithCriterion", &bmi_equations_with_criterion },
    { "FactorDerivative", &bmi_factor_derivative },
    { "FieldElement", &bmi_field_element },
    { "FrozenSymbols", &bmi_frozen_symbols },
    { "Indets", &bmi_indets },
    { "IsOrthonomic", &bmi_is_orthonomic },
    { "IsReduced", &bmi_is_reduced },
    { "LeadingCoefficient", &bmi_leading_coefficient },
    { "LeadingDerivative", &bmi_leading_derivative },
    { "LeadingRank", &bmi_leading_rank },
    { "MaxRankElement", &bmi_max_rank_element },
    { "MinRankElement", &bmi_min_rank_element },
    { "NormalForm", &bmi_normal_form },
    { "NormalFormHandlingExceptions", &bmi_normal_form_handling_exceptions },
    { "Parameters", &bmi_parameters },
    { "Pardi", &bmi_pardi },
    { "PreparationEquation", &bmi_preparation_equation },
    { "PretendRegularDifferentialChain", &bmi_pretend_regchain },
    { "ProcessExpansionPoint", &bmi_process_expansion_point },
    { "Ranking", &bmi_ranking },
    { "ReducedForm", &bmi_reduced_form },
    { "RewriteRules", &bmi_rewrite_rules },
    { "RewriteRulesWithCriterion", &bmi_rewrite_rules_with_criterion },
    { "RosenfeldGroebner", &bmi_Rosenfeld_Groebner },
    { "Separant", &bmi_separant },
    { "SortByRank", &bmi_sort_by_rank },
    { "Tail", &bmi_tail }
};

#define NARGS(t) (sizeof(t)/sizeof(*(t)))

/*
 * For bsearch
 */

static int bmi_compare_identifier (const void* _name, const void* _pair)
{   char* name = (char*)_name;
    struct bmi_exported_pair* pair = (struct bmi_exported_pair*)_pair;

    return strcmp (name, pair->name);
}

static struct bmi_exported_pair* get_bmi_exported_pair (char* name)
{   struct bmi_exported_pair* pair;

    pair = (struct bmi_exported_pair*)bsearch 
		(name, bmi_exported_table, NARGS(bmi_exported_table), 
		 sizeof (struct bmi_exported_pair), &bmi_compare_identifier);
    return pair;
}

/*
 * This variable is involved in an error which arises at debugging stage only
 * It is thus harmless.
 */

#define BMIBUFSZ 256
static char bmi_exported_mesgerr [BMIBUFSZ];

ALGEB bmi_call_exported (char* name, struct bmi_callback* callback)
{   struct bmi_exported_pair* pair;
    ALGEB res;

    pair = get_bmi_exported_pair (name);
    if (pair == (struct bmi_exported_pair*)0)
/*
 * This should not happen error
 */
    {	strcpy (bmi_exported_mesgerr, BMI_ERRFUN);
	strcat (bmi_exported_mesgerr, ": ");
	strncat (bmi_exported_mesgerr, name, 
			BMIBUFSZ - strlen (bmi_exported_mesgerr) - 5);
	BA0_RAISE_EXCEPTION (bmi_exported_mesgerr);
    }
/*
    fprintf (stderr, "bmi_call_exported: %s\n", pair->name);
*/
    res = (*pair->pointer) (callback);
    MapleGcProtect (callback->kv, res);
/*
    fprintf (stderr, "bmi_call_exported: out\n");
*/
    return res;
}

