#ifndef BMI_CALLBACK_H
#define BMI_CALLBACK_H 1

/*
 * Here is an example of a call to bmi_blad_eval.
 *
 * arguments := "NormalForm" (convert (leqns, string), drideal)
 * arguments := arguments,
 *             ToBMIOptionSequence 
 *             		(innot, outnot, _TIMEOUT_, _MEMOUT_, _CELLSZ_);
 * result := BMIBladEval (arguments);
 *
 * This module permits to the exported function (in this case,
 * bmi_normal_form) to access to its two arguments (a list of
 * differential rational fractions in string form, and a table
 * describing a ring or an ideal).
 *
 * The exported function accesses to its arguments through a data
 * structure "callback" and the functions listed below.
 */

/*
 * Including blad.h before maplec.h is important
 */

#include <blad.h>

#if ! defined (MAPLE)
#    include "config.h"
#endif

#include <maplec.h>

BEGIN_C_DECLS

struct bmi_callback {
    MKernelVector kv;
			/* The object the following functions apply to */
    ALGEB arg;
                        /* MAPLE keywords */
    ALGEB op;
    ALGEB nops;
                        /* indices in MAPLE tables */
    ALGEB ordering;
    ALGEB equations;
    ALGEB notation;
    ALGEB type;
};

extern void bmi_init_callback (struct bmi_callback*);
extern void bmi_gc_allow_callback (struct bmi_callback*);
extern void bmi_gc_protect_callback (struct bmi_callback*);
extern void bmi_clear_callback (struct bmi_callback*);

extern void bmi_set_callback_maple (struct bmi_callback*, MKernelVector, ALGEB);

extern long bmi_nops (struct bmi_callback*);

extern bool bmi_is_string_op (long, struct bmi_callback*);
extern bool bmi_is_table_op (long, struct bmi_callback*);
extern bool bmi_is_dring_op (long, struct bmi_callback*);
extern bool bmi_is_regchain_op (long, struct bmi_callback*);

extern bool bmi_bool_op (long, struct bmi_callback*);
extern char* bmi_string_op (long, struct bmi_callback*);
extern char* bmi_table_type_op (long, struct bmi_callback*);
extern char* bmi_table_notation_op (long, struct bmi_callback*);
extern ALGEB bmi_table_ordering_op (long, struct bmi_callback*);
extern ALGEB bmi_table_equations_op (long, struct bmi_callback*);

END_C_DECLS

#endif /* BMI_CALLBACK_H */
