<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" language="java"%>
<%@ taglib uri="http://jakarta.apache.org/struts/tags-html"
	prefix="html"%>
<%@ taglib uri="http://jakarta.apache.org/struts/tags-bean"
	prefix="bean"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles"%>
<%@ taglib uri="http://displaytag.sf.net" prefix="display"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<%@ taglib uri="http://jakarta.apache.org/struts/tags-logic" prefix="logic"%>

<tiles:useAttribute name="actionMapping"/>
<tiles:useAttribute name="include_roles_filter" ignore="true"/>
<tiles:useAttribute name="radio_toggle" ignore="true"/>
<tiles:useAttribute name="no_register" ignore="true"/>

<fmt:bundle
	basename="com.maplesoft.mapleta.application.ApplicationResources">

	<c:set var="uid">
		<fmt:message key="UserAdmin.uid.label" />
	</c:set>
	<c:set var="firstname">
		<fmt:message key="UserAdmin.firstname.label" />
	</c:set>
	<c:set var="lastname">
		<fmt:message key="UserAdmin.lastname.label" />
	</c:set>
	<c:set var="email">
		<fmt:message key="UserAdmin.email.label" />
	</c:set>
	<c:set var="studentID">
		<fmt:message key="UserAdmin.studentID.label" />
	</c:set>

</fmt:bundle>

<fmt:bundle
	basename="com.maplesoft.mapleta.application.ApplicationResources">

	<c:set var="select_user">
		<c:choose>
			<c:when test="${radio_toggle == 'true'}">
				<fmt:message key="ClassManagerSearchForm.user.register.select.one.msg" />
			</c:when>
			<c:otherwise>
				<fmt:message key="ClassManagerSearchForm.user.register.select.msg" />
			</c:otherwise>
		</c:choose>
	</c:set>

	<script language="javascript">
		function submitForm() {
			var els = document.getElementsByName("selectedItems");
	
			for (i=0; i < els.length; i++) {
				if (els[i].checked == true) {
					doSubmit();
					return true;
				}
			}
	
			alert("${select_user}");
		}
			
		function doSubmit() {
			document.getElementById("userForm").submit();
			return true;
		}
	</script>

	<c:set var="select_toggle">
		<c:choose>
			<c:when test="${no_register == 'true'}">Update</c:when>
			<c:otherwise>Register</c:otherwise>
		</c:choose>
	</c:set>

	<c:set var="select_toggle_label">
		<c:choose>
			<c:when test="${no_register == 'true'}">
				<fmt:message
					key="ClassManagerSearchForm.table.columnheader.update.label" />
			</c:when>
			<c:otherwise>
				<fmt:message
					key="ClassManagerSearchForm.table.columnheader.register.label" />
			</c:otherwise>
		</c:choose>
	</c:set>


	<a href="#" onClick="toggleItem('search'); this.blur(); return false;">
		<span class="toggle"> <img
				src="modules/configureClasses/images/closeDirIcon.gif" border="0"
				id="searchTwisty"> <fmt:message
				key="ClassManagerSearchForm.useradmin.user.search.panel.label" /> </span> </a>


	<div class="search" id="searchTable">
		<tiles:insert definition=".classmanager.useradmin.search"
			flush="false">
			<tiles:put name="actionMapping" value="${actionMapping}"/>
		</tiles:insert>
	</div>
	<script>initTwisty();</script>

	<html:messages id="msg" message="false">
		<span class="errorStyle1"><c:out value='${msg}' /></span>
		<br>
	</html:messages>

	<c:choose>
		<c:when test="${fn:length(users) gt 0}">

			<p>
				&nbsp;
			</p>

			<em class="title">
			<c:choose>
				<c:when test="${radio_toggle == 'true'}">
					<fmt:message
							key="ClassManagerSearchForm.table.header.add.user.instructor.msg" />
				</c:when>
				<c:otherwise>
					<fmt:message
							key="ClassManagerSearchForm.table.header.add.users.msg" />
				</c:otherwise>
			</c:choose>
			</em>

			<p></p>

			<html:form method="post" action="${actionMapping}" styleId="userForm">

				<html:hidden property="dispatch" value="${select_toggle}" />

		<c:choose>
			<c:when test="${radio_toggle == 'true'}">
				<bean:define id="student_toggle" toScope="page">
					<fmt:message key="ClassManagerSearchForm.table.columnheader.register.label" />
				</bean:define>
			</c:when>
			<c:otherwise>
				<bean:define id="student_toggle" toScope="page">
					<input type="checkbox" onclick="selectAllItems(this);" />&nbsp;<fmt:message
						key="ClassManagerSearchForm.table.columnheader.register.label" />
				</bean:define>
			</c:otherwise>
		</c:choose>
		
				<p></p>

			<c:if test="${include_roles_filter != 'false'}">
				<tiles:insert definition=".user.roles.filter" flush="false">
					<tiles:put name="allow_unset_role" value="false" />
				</tiles:insert>
			</c:if>
			
				<html:hidden property="dispatch" value="add" />
				
				<p></p>
				
				<html:button property="dispatch" styleClass="button"
					value="${select_toggle_label}" onclick="submitForm();" />
				
				<display:table id="row" name="${users}" defaultsort="2" pagesize="${pageLimit}"
					requestURI="/classmanager${actionMapping}.do" sort="list" class="simple">
					<%@ include file="/WEB-INF/jsp/displaytag_defaultProperties.jsp" %>
					<display:setProperty name="paging.banner.placement" value="bottom" />

					<display:column title="${student_toggle}">
				<c:choose>
					<c:when test="${radio_toggle == 'true'}">
						<html:radio property="selectedItems" value="${row.id}"/>
					</c:when>
					<c:otherwise>
						<html:multibox property="selectedItems" value="${row.id}" />
					</c:otherwise>
				</c:choose>	

					</display:column>

					<display:column property="uid" title="${uid}" sortable="true" />
					<display:column property="givenName" sortable="true"
						title="${firstname}" />
					<display:column property="sn" sortable="true" title="${lastname}" />
					<display:column property="email" sortable="true" title="${email}" />
					<display:column property="studentID" sortable="true"
						title="${studentID}" />
				</display:table>

				<br>
				<br>
				<html:button property="dispatch" styleClass="button"
					value="${select_toggle_label}" onclick="submitForm();" />

			</html:form>

		</c:when>
		<c:otherwise>
			<logic:present name="users">
				<br />
				<br />
				<fmt:message key="classmanager.no_students.msg" />
			</logic:present>
		</c:otherwise>
	</c:choose>
</fmt:bundle>
