<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" language="java"%>

<%@ page import="com.maplesoft.mapleta.application.Constants"%>
<%@ taglib uri="http://jakarta.apache.org/struts/tags-html"
	prefix="html"%>
<%@ taglib uri="http://jakarta.apache.org/struts/tags-bean"
	prefix="bean"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles"%>
<%@ taglib uri="http://displaytag.sf.net" prefix="display"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<%@ taglib uri="http://jakarta.apache.org/struts/tags-logic" prefix="logic"%>

<fmt:bundle
	basename="com.maplesoft.mapleta.application.ApplicationResources">

	<c:set var="uid">
		<fmt:message key="UserAdmin.uid.label" />
	</c:set>
	<c:set var="firstname">
		<fmt:message key="UserAdmin.firstname.label" />
	</c:set>
	<c:set var="lastname">
		<fmt:message key="UserAdmin.lastname.label" />
	</c:set>
	<c:set var="email">
		<fmt:message key="UserAdmin.email.label" />
	</c:set>
	<c:set var="studentID">
		<fmt:message key="UserAdmin.studentID.label" />
	</c:set>
	<c:set var="role">
		<fmt:message key="UserEditForm.roles.label" />
	</c:set>

</fmt:bundle>


<fmt:bundle
	basename="com.maplesoft.mapleta.application.ApplicationResources">

	<a href="#" onClick="toggleItem('search'); this.blur(); return false;">
		<span class="toggle"> <img
				src="modules/configureClasses/images/closeDirIcon.gif" border="0"
				id="searchTwisty"> <fmt:message
				key="ClassManagerSearchForm.classmanager.user.search.panel.label" />
	</span> </a>

	<div class="search" id="searchTable">
		<tiles:insert definition=".classmanager.user.search" flush="false">
			<tiles:put name="actionMapping" value="/RemoveUser" />
		</tiles:insert>
	</div>
	<script>initTwisty();</script>

	<html:messages id="msg" message="false">
		<span class="errorStyle1"><c:out value='${msg}' /></span>
		<br>
	</html:messages>

	<c:set var="select_user">
		<fmt:message key="ClassManagerSearchForm.user.remove.select.msg" />
	</c:set>

	<script language="javascript">
	function submitForm() {
		var els = document.getElementsByName("selectedItems");

		for (i=0; i < els.length; i++) {
			if (els[i].checked == true) {
				doSubmit();
				return true;
			}
		}

		alert("${select_user}");
	}
		
	function doSubmit() {
		document.getElementById("userForm").submit();
		return true;
	}
</script>

	<c:set var="select_toggle">Remove</c:set>

	<c:set var="select_toggle_label">
		<fmt:message
			key="ClassManagerSearchForm.table.columnheader.remove.label" />
	</c:set>

	<c:choose>
		<c:when test="${fn:length(users) gt 0}">

			<p>
				&nbsp;
			</p>

			<em class="title"><fmt:message
					key="ClassManagerSearchForm.table.header.remove.users.msg" /> </em>

			<p></p>

			<html:form action="/RemoveUser" method="post" styleId="userForm">

				<html:hidden property="dispatch" value="${select_toggle}" />

				<bean:define id="student_toggle" toScope="page">
					<input type="checkbox" onclick="selectAllItems(this);" />&nbsp;<fmt:message
						key="ClassManagerSearchForm.table.columnheader.remove.label" />
				</bean:define>

				<br>

				<html:button property="mode" styleClass="button"
					value="${select_toggle_label}" onclick="submitForm();" />

				<display:table id="row" name="${users}" defaultsort="2" pagesize="${pageLimit}"
					requestURI="/classmanager/RemoveUser.do" sort="list" class="simple">
					
					<%@ include file="/WEB-INF/jsp/displaytag_defaultProperties.jsp" %>
					<display:setProperty name="paging.banner.placement" value="bottom" />

					<display:column title="${student_toggle}">
						<html:multibox property="selectedItems" value="${row.id}" />
					</display:column>

					<display:column title="${uid}" sortable="true">
						<html:link action="/UserInfo.do?uid=${row.uid}">${row.uid}</html:link>
					</display:column>
					<display:column property="givenName" sortable="true"
						title="${firstname}" />
					<display:column property="sn" sortable="true" title="${lastname}" />
					<display:column property="email" sortable="true" title="${email}" />
					<display:column property="studentID" sortable="true"
						title="${studentID}" />
					<display:column property="role" sortable="true" title="${role}" />

				</display:table>

				<br>
				<br>
				<html:button property="mode" styleClass="button"
					value="${select_toggle_label}" onclick="submitForm();" />

			</html:form>

		</c:when>
		<c:otherwise>
			<logic:present name="users">
				<br />
				<br />
				<fmt:message key="classmanager.no_students.msg" />
			</logic:present>
		</c:otherwise>
	</c:choose>

</fmt:bundle>
