<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" language="java"%>

<%@ taglib uri="http://jakarta.apache.org/struts/tags-html"	prefix="html"%>
<%@ taglib uri="http://jakarta.apache.org/struts/tags-logic" prefix="logic"%>
<%@ taglib uri="http://jakarta.apache.org/struts/tags-bean"	prefix="bean"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles"%>

<fmt:setBundle
	basename="com.maplesoft.mapleta.application.ApplicationResources"
	scope="request" />

<!-- %Import the JSCalendar -->
<style type="text/css">@import url(jscalendar-1.0/skins/aqua/theme.css);</style>
<script type="text/javascript" src="jscalendar-1.0/calendar.js"></script>
<script type="text/javascript" src="jscalendar-1.0/lang/calendar-en.js"></script>
<script type="text/javascript" src="jscalendar-1.0/lang/calendar-${MTA_LOCALE}-utf8.js"></script>
<script type="text/javascript" src="jscalendar-1.0/calendar-setup.js"></script>

<script type="text/javascript">
var msgPassingScoreRules="<fmt:message key='msg.AssignmentEditorPolicy.PassingScoreRules'/>";
var msgTimeLimitRules="<fmt:message key='msg.AssignmentEditorPolicy.TimeLimitRules'/>";
var msgNumberOfQuestionsRules="<fmt:message key='msg.AssignmentEditorPolicy.NumberOfQuestionsRules'/>";
var msgNumberOfQuestionsTooBig="<fmt:message key='msg.AssignmentEditorPolicy.NumberOfQuestionsTooBig'/>";
var msgStartAndEndDates="<fmt:message key='msg.AssignmentEditorPolicy.StartAndEndDates'/>";
var msgAssignmentDurationTooSmall="<fmt:message key='msg.AssignmentEditorPolicy.AssignmentDurationTooSmall'/>";
var msgInSessionGradeReportedNote="<fmt:message key='msg.AssignmentEditorPolicy.InSessionGradeReportedNote'/>";
var msgEmailNotificationWarning="<fmt:message key='msg.AssignmentEditorPolicy.EmailNotificationWarning'/>";
var msgMasteryEditWarning="<fmt:message key='msg.AssignmentEditorPolicy.MasteryEditWarning'/>";
var msgAllowResubmitTitle="<fmt:message key='msg.AssignmentEditorPolicy.AllowResubmitTitle'/>";
var msgAllowResubmitWarning="<fmt:message key='msg.AssignmentEditorPolicy.AllowResubmitWarning'/>";
var msgShowLockdownTitle="<fmt:message key='msg.AssignmentEditorPolicy.ShowLockdownTitle'/>";
var msgShowLockdownWarning='<fmt:message key='msg.AssignmentEditorPolicy.ShowLockdownWarning'/>';
var msgBlockButton="<fmt:message key='msg.AssignmentEditorPolicy.BlockButton'/>";
var msgIgnoreButton="<fmt:message key='msg.AssignmentEditorPolicy.IgnoreButton'/>";
var msgSwitchButton="<fmt:message key='msg.AssignmentEditorPolicy.SwitchButton'/>";

function calculateTotal()
{
	var full = "";
	
	$('#groups input:checked').each(function(){
		full += "#= " + $(this).siblings('label').html() + "\n";
		full += $(this).attr('ranges') + "\n\n";
	});
	
	if( $.trim($("#customGroups").val()).length > 0 )
	{
		full += "#= ClassCustom\n" + $("#customGroups").val();
	}
	
	$(".assignmentGroups").val(full);
}
function addSystemGroup(name, ranges){
	var cleanName = name.replace(" ", "");
	
	$('#groups').append("<tr><td><input type='checkbox' class='groupName' ranges='" + ranges + "' id='" + cleanName + "'/><label for='" + cleanName + "'>" + name + "</label></td>");
}
$(function(){			
	// Split the system groups and show the checkboxes
	var fullVal = $.trim($('.systemGroups').val());
	
	if( fullVal.length > 0 ){
		var split = fullVal.split('#=');
		
		$(split).each(function(){
			if( $.trim(this).length > 0 ){
				var name = "";
				var value = "";
				
				$(this.split('\n')).each(function(){
					if( name == ""){
						name = $.trim(this);
					}else{
						value = value + $.trim(this) + "\n";
					}
				});
				
				addSystemGroup(name,value);
			}
		});
	}
	
	// Split the assignment selected groups and show the checkboxes and the custom value
	var assignmentVal = $.trim($('.assignmentGroups').val());
	
	if( assignmentVal.length > 0 ){
		var split = assignmentVal.split('#=');
		
		$(split).each(function(){
			if( $.trim(this).length > 0 ){
				var name = "";
				var value = "";
				
				$(this.split('\n')).each(function(){
					if( name == ""){
						name = $.trim(this);
					}else{
						value = value + $.trim(this) + "\n";
					}
				});
				
				var cleanName = name.replace(" ", "");		
				
				if( cleanName != "ClassCustom"){
					$('#groups #' + cleanName).attr("checked", "checked");
				}else{
					$("#customGroups").val(value);
				}
			}
		});
	}
	
	
	$('#groups input').click(calculateTotal);
	$('#customGroups').bind('keyup', calculateTotal);
	
});
</script>

<script src="modules/contentmanager/assignment/assignmentEditorPolicies.js"></script>


<html:messages id="msg">
	<div class="warning" align="center">
		<c:out value="${msg}"/>
	</div>
</html:messages>

<BR>
<BR>


<table align="center" class="tabular_list" width="800">
	<tr class="head">
		<th colspan="3">
			<fmt:message key="AssignmentEditorPolicy.TypeOfAssignment.Label"/>
		</th>
		<th>
			<fmt:message key="AssignmentEditorPolicy.Results.Label"/>
		</th>
	</tr>
	<c:if test="${! AssignmentEditForm.fobidAnonynousPractice}">
		<tr>
			<td>
				<c:choose>
					<c:when test="${AssignmentEditForm.active}">
						<html:radio property="modeOrdinal" value="2" disabled="true"/>
					</c:when>
					<c:otherwise>
						<html:radio property="modeOrdinal" value="2" onclick="modeClicked(this.value)"/>
					</c:otherwise>
				</c:choose>
			</td>
			<td>
				<b><fmt:message key="AssignmentEditorPolicy.AnonymousPractice.Label"/></b>
			</td>
			<td>
				<fmt:message key="AssignmentEditorPolicy.NoSessionResultsAreRecorded.Label"/>
			</td>
			<td>
				<fmt:message key="AssignmentEditorPolicy.NotRecorded.Label"/>
			</td>
		</tr>
	</c:if>
	<tr>
		<td>
			<c:choose>
				<c:when test="${AssignmentEditForm.active}">
					<html:radio property="modeOrdinal" value="1" disabled="true"/>
				</c:when>
				<c:otherwise>
					<html:radio property="modeOrdinal" value="1" onclick="modeClicked(this.value)"/>
				</c:otherwise>
			</c:choose>
		</td>
		<td>
			<b><fmt:message key="AssignmentEditorPolicy.HomeworkOrQuiz.Label"/></b>
		</td>
		<td>
			<fmt:message key="AssignmentEditorPolicy.AllSessionResultsAreRecorded.Label"/>
		</td>
		<td>
			<fmt:message key="AssignmentEditorPolicy.Recorded.Label"/>
		</td>
	</tr>
	<tr class="sub_part">
		<td></td>
		<td colspan="4">
			<c:choose>
				<c:when test="${AssignmentEditForm.active}">
					<html:checkbox property="reworkable" disabled="true"/>
				</c:when>
				<c:otherwise>
					<html:checkbox property="reworkable" onclick="reworkableClicked();"/>
				</c:otherwise>
			</c:choose>
			<fmt:message key="AssignmentEditorPolicy.Reworkable.Label"/>
		</td>
	</tr>
	<tr class="sub_part">
		<td></td>
		<td colspan="4">
			<c:choose>
				<c:when test="${AssignmentEditForm.active}">
					<html:checkbox property="targeted" disabled="true"/>
				</c:when>
				<c:otherwise>
					<html:checkbox property="targeted" onclick="targetedClicked();"/>
				</c:otherwise>
			</c:choose>
			<fmt:message key="AssignmentEditorPolicy.CarryOverCredits.Label"/>
		</td>
	</tr>
	<tr class="sub_part">
		<td></td>
		<td colspan="4">
			<c:choose>
				<c:when test="${AssignmentEditForm.active && AssignmentEditForm.modeOrdinal != 1}">
					<html:checkbox property="printable" disabled="true"/>
				</c:when>
				<c:otherwise>
					<html:checkbox property="printable" onclick="printableClicked();"/>
				</c:otherwise>
			</c:choose>
			<fmt:message key="AssignmentEditorPolicy.Printable.Label"/>
		</td>
	</tr>
	<tr>
		<td>
			<c:choose>
				<c:when test="${AssignmentEditForm.active}">
					<html:radio property="modeOrdinal" value="0" disabled="true"></html:radio>
				</c:when>
				<c:otherwise>
					<html:radio property="modeOrdinal" value="0" onclick="modeClicked(this.value)"></html:radio>
				</c:otherwise>
			</c:choose>
		</td>
		<td>
			<b><fmt:message key="AssignmentEditorPolicy.ProctoredExam.Label"/></b>
		</td>
		<td>
			<fmt:message key="AssignmentEditorPolicy.RequiresProctorAuthorizationToGrade.Label"/>
		</td>
		<td>
			<fmt:message key="AssignmentEditorPolicy.Recorded.Label"/>
		</td>
	</tr>
	<tr class="sub_part">
		<td></td>
		<td colspan="4">
			<c:choose>
				<c:when test="${AssignmentEditForm.active && AssignmentEditForm.modeOrdinal != 0}">
					<html:checkbox property="startAuthorizationRequired" disabled="true"/>
				</c:when>
				<c:otherwise>
					<html:checkbox property="startAuthorizationRequired" onclick="startAuthorizationRequiredClicked()"/>
				</c:otherwise>
			</c:choose>
			<fmt:message key="AssignmentEditorPolicy.AlsoRequireProctorSignInToStartSession.Label"/>
		</td>
	</tr>	 
	<tr>
		<td>
			<c:choose>
				<c:when test="${AssignmentEditForm.active}">
					<html:radio property="modeOrdinal" value="3" disabled="true"></html:radio>
				</c:when>
				<c:otherwise>
					<html:radio property="modeOrdinal" value="3" onclick="modeClicked(this.value)"></html:radio>
				</c:otherwise>
			</c:choose>
		</td>
		<td>
			<b><fmt:message key="AssignmentEditorPolicy.MasteryDdialog.Label"/></b>
		</td>
		<td>
			<fmt:message key="AssignmentEditorPolicy.ControlProgressQuestionByQuestion.Label"/>
		</td>
		<td>
			<fmt:message key="AssignmentEditorPolicy.Recorded.Label"/>
		</td>
	</tr>
	<tr class="sub_part">
		<td></td>
		<td colspan="4">
			<c:if test="${!AssignmentEditForm.active}">
				<a href="javascript:mastery()"><fmt:message key="AssignmentEditorPolicy.EditMasteryPolicies.Label"/></a>
			</c:if>
		</td>
	</tr>
	<c:if test="${! AssignmentEditForm.fobidAnonynousPractice}">
		<tr>
			<td>
				<c:choose>
					<c:when test="${AssignmentEditForm.active}">
						<html:radio property="modeOrdinal" value="4" disabled="true"></html:radio>
					</c:when>
					<c:otherwise>
						<html:radio property="modeOrdinal" value="4" onclick="modeClicked(this.value)"></html:radio>
					</c:otherwise>
				</c:choose>
			</td>
			<td>
				<b><fmt:message key="AssignmentEditorPolicy.StudySsessionDialog.Label"/></b>
			</td>
			<td>
				<fmt:message key="AssignmentEditorPolicy.FlashcardSstyleLearning.Label"/>
			</td>
			<td>
				<fmt:message key="AssignmentEditorPolicy.NotRecorded.Label"/>
			</td>
		</tr>
	</c:if>
	

	<tr class="head">
		<th colspan="5">
			<fmt:message key="AssignmentEditorPolicy.Feedback.Label"/>
		</th>
	</tr>

	<tr>
		<td></td>
		<td colspan="4">
			<b><fmt:message key="AssignmentEditorPolicy.DuringTheAssignment.Label"/></b>
		</td>
	</tr>

	<tr class="sub_part">
		<td></td>
		<td align="left">
			<html:checkbox property="hintsShown"/>
			<fmt:message key="AssignmentEditorPolicy.ShowHints.Label"/>
		</td>
	</tr>
	<tr class="sub_part">
		<td></td>
		<td align="left">
			<html:checkbox property="showCurrentGrade" styleId="showCurrentGrade"/>
			<fmt:message key="AssignmentEditorPolicy.ShowCurrentGrade.Label"/>
		</td>
	</tr>
	<tr class="sub_part">
		<td></td>
		<td align="left">
			<html:checkbox property="allowResubmitQuestion" styleId="allowResubmitQuestion"/>
			<fmt:message key="AssignmentEditorPolicy.AllowResubmitQuestion.Label"/>
		</td>
	</tr>
	<tr class="sub_part">
		<td></td>
		<td colspan="4">
			<html:checkbox property="inSessionGradeReported" onclick="inSessionGradeReportChanged()"/>
			<fmt:message key="AssignmentEditorPolicy.AllowSstudentsToCheckGradesAndFeedback.Label"/>
			<br>
			<fmt:message key="AssignmentEditorPolicy.ForEachQuestion.Label"/> &nbsp;&nbsp;
			<html:select property="showInSessionAnswer" onchange="inSessionMenuChanged()">
				<html:option value="0" key="AssignmentEditorPolicy.Always.Option"/> 
				<html:option value="1" key="AssignmentEditorPolicy.IfCorrect.Option"/> 
				<html:option value="2" key="AssignmentEditorPolicy.IfIncorrect.Option"/> 
				<html:option value="3" key="AssignmentEditorPolicy.Never.Option"/> 
			</html:select>
			<fmt:message key="AssignmentEditorPolicy.ShowTheCorrectAnswer.Label"/> &nbsp;&nbsp;
			<html:select property="showInSessionComment" onchange="inSessionMenuChanged()">
				<html:option value="0" key="AssignmentEditorPolicy.Always.Option"/> 
				<html:option value="1" key="AssignmentEditorPolicy.IfCorrect.Option"/> 
				<html:option value="2" key="AssignmentEditorPolicy.IfIncorrect.Option"/> 
				<html:option value="3" key="AssignmentEditorPolicy.Never.Option"/> 
			</html:select>
			<fmt:message key="AssignmentEditorPolicy.ShowTheQuestionComment.Label"/>
		</td>
	</tr>
	<tr>
		<td></td>
		<td colspan="4">
			<b><fmt:message key="AssignmentEditorPolicy.AfterTheAssignmentIsGraded.Label"/></b>
		</td>
	</tr>
	<tr class="sub_part">
		<td></td>
		<td colspan="4">
			<html:checkbox property="gradeReported"></html:checkbox>
			<fmt:message key="AssignmentEditorPolicy.ShowTheFinalGrade.Label"/>
			<p>
				<a href="javascript:gradeFeedback()"><fmt:message key="AssignmentEditorPolicy.EditGradingMessage.Label"/></a>
			<p>
			<fmt:message key="AssignmentEditorPolicy.ForEachQuestion.Label"/> &nbsp;&nbsp;
			<html:select property="showAnswer">
				<html:option value="0" key="AssignmentEditorPolicy.Always.Option"/> 
				<html:option value="1" key="AssignmentEditorPolicy.IfCorrect.Option"/> 
				<html:option value="2" key="AssignmentEditorPolicy.IfIncorrect.Option"/> 
				<html:option value="3" key="AssignmentEditorPolicy.Never.Option"/> 
			</html:select>
			<fmt:message key="AssignmentEditorPolicy.ShowTheCorrectAnswer.Label"/> &nbsp;&nbsp;
			<html:select property="showComment">
				<html:option value="0" key="AssignmentEditorPolicy.Always.Option"/> 
				<html:option value="1" key="AssignmentEditorPolicy.IfCorrect.Option"/> 
				<html:option value="2" key="AssignmentEditorPolicy.IfIncorrect.Option"/> 
				<html:option value="3" key="AssignmentEditorPolicy.Never.Option"/> 
			</html:select>
			<fmt:message key="AssignmentEditorPolicy.ShowTheQuestionComment.Label"/>
			<br>
			<html:checkbox property="emailNotified" onclick="emailNotifiedClicked()"/>
			<fmt:message key="AssignmentEditorPolicy.SendEmailReportsTo.Label"/>
			<html:text property="address" size="20"/>
			<br>
			<br>
			<html:checkbox property="restrictDatePresent" styleId="restrictDatePresent" onclick="setSchedDate(this, 'restrictDate_if', 'restrictDate_da');"/>
			<fmt:message key="AssignmentEditorPolicy.RestrictFeedbackUntil.Label"/>


			<html:hidden property="restrictDate" styleId="restrictDate_if"/>

			<input type="text" readonly="readonly" size="25" id="restrictDate_da"/>
			<img src="jscalendar-1.0/img.gif" id="restrictDate_trigger" onclick="calOnClick(this, 'restrictDate_if', 'restrictDate_da', 'restrictDatePresent', 'true');"/>
			<a href="javascript:clearClicked('restrictDate_if', 'restrictDate_da', 'restrictDatePresent')"><fmt:message key="AssignmentEditorPolicy.Clear.Label"/></a>
			<p>
				<fmt:message key="AssignmentEditorPolicy.DelayFeedbackDescription.Label"/>
			</p>
		</td>

	</tr>
	<tr class="head">
		<th colspan="5">
			<fmt:message key="AssignmentEditorPolicy.AssignmentProperties.Label"/>
		</th>
	</tr>
	<tr>
		<td></td>
		<td colspan="5">
			<fmt:message key="AssignmentEditorPolicy.PassingScore.Label"/>
			<html:text property="passingScore" size="3" maxlength="3" value="${AssignmentEditForm.passingScore <= 0 ? '' : AssignmentEditForm.passingScore}"/> 
			<fmt:message key="AssignmentEditorPolicy.OutOf.Label"/> 
			${AssignmentEditForm.assignmentTotalPoints}
			<p>
				<a href="javascript:customFeedback()"><fmt:message key="AssignmentEditorPolicy.EditFeedbackMessages.Label"/></a>
			<p>
				<fmt:message key="AssignmentEditorPolicy.ShowPassFailFeedBack.Label"/> &nbsp;&nbsp;
			<html:select property="showPassFailFeedback">
				<html:option value="0" key="AssignmentEditorPolicy.Always.Option"/> 
				<html:option value="3" key="AssignmentEditorPolicy.Never.Option"/> 
				<html:option value="4" key="AssignmentEditorPolicy.IfTheFinalGradeIsShown.Option"/> 
			</html:select>
			</p>
		</td>
	</tr>
	<tr>
		<td></td>
		<td colspan="5">
			<fmt:message key="AssignmentEditorPolicy.TimeLimit.Label"/>
			<html:text property="timeLimit" size="3" maxlength="3" value="${AssignmentEditForm.timeLimit <= 0 ? '' : AssignmentEditForm.timeLimit}"/>
			<fmt:message key="AssignmentEditorPolicy.Minutes.Label"/>
		</td>
	</tr>
	<tr>
		<td></td>
		<td colspan="5">
			<fmt:message key="AssignmentEditorPolicy.QuestionsPerPage.Label"/>
			<html:text property="quPerPage" size="3" maxlength="3"/>
		</td>
	</tr>
	<tr>
		<td></td>
		<td colspan="5">
			<fmt:message key="AssignmentEditorPolicy.MaxAttemptsAllowed.Label"/>
			<c:choose>
				<c:when test="${AssignmentEditForm.maxAttemptsAllowed}">
					<html:select property="maxAttempts">
						<html:option value="-1"><fmt:message key="AssignmentEditorCommon.Empty.Option"/></html:option>
						<html:option value="1"><fmt:message key="AssignmentEditorCommon.1.Option"/></html:option>
						<html:option value="2"><fmt:message key="AssignmentEditorCommon.2.Option"/></html:option>
						<html:option value="3"><fmt:message key="AssignmentEditorCommon.3.Option"/></html:option>
						<html:option value="4"><fmt:message key="AssignmentEditorCommon.4.Option"/></html:option>
						<html:option value="5"><fmt:message key="AssignmentEditorCommon.5.Option"/></html:option>
					</html:select>
				</c:when>
				<c:otherwise>
					<html:select property="maxAttempts" disabled="true">
						<html:option value="-1"><fmt:message key="AssignmentEditorCommon.Empty.Option"/></html:option>
						<html:option value="1"><fmt:message key="AssignmentEditorCommon.1.Option"/></html:option>
						<html:option value="2"><fmt:message key="AssignmentEditorCommon.2.Option"/></html:option>
						<html:option value="3"><fmt:message key="AssignmentEditorCommon.3.Option"/></html:option>
						<html:option value="4"><fmt:message key="AssignmentEditorCommon.4.Option"/></html:option>
						<html:option value="5"><fmt:message key="AssignmentEditorCommon.5.Option"/></html:option>
					</html:select>
					<p>
						<fmt:message key="AssignmentEditorPolicy.AdvancedPolicyExists.Label"/>
					</p>
				</c:otherwise>
			</c:choose>
		</td>
	</tr>

	<tr>
		<td></td>
		<td colspan="4">
			<b><fmt:message key="AssignmentEditorPolicy.Scheduling.Label"/></b> 
			<fmt:message key="AssignmentEditorCommon.OpenBrace.Label"/>${AssignmentEditForm.timeZone}<fmt:message key="AssignmentEditorCommon.CloseBrace.Label"/>
		</td>
	</tr>
	<tr class="sub_part">
		<td></td>
		<td colspan="4">
			<table width="100%">
				<tr>
					<td width="100">
						<c:choose>
							<c:when test="${!AssignmentEditForm.active}">
								<html:checkbox property="startDatePresent" styleId="startDatePresent" onclick="setSchedDate(this, 'startDate_if', 'startDate_da');"/>
							</c:when>
							<c:otherwise>
								<html:checkbox property="startDatePresent" styleId="startDatePresent" disabled="true"/>
							</c:otherwise>
						</c:choose>
						<b><fmt:message key="AssignmentEditorPolicy.Start.Label"/></b>
					</td>
					<td colspan="2">
						<html:hidden property="startDate" styleId="startDate_if"/>
						<c:choose>
							<c:when test="${!AssignmentEditForm.active}">
								<input type="text" readonly="readonly" size="25" id="startDate_da" onclick="calOnClick(this, 'startDate_if','startDate_da','startDatePresent', 'true');"/>
								<img src="jscalendar-1.0/img.gif" id="startDate_trigger" onclick="calOnClick(this, 'startDate_if', 'startDate_da','startDatePresent', 'true');"/>
								<a href="javascript:clearClicked('startDate_if', 'startDate_da', 'startDatePresent')"><fmt:message key="AssignmentEditorPolicy.Clear.Label"/></a>
							</c:when>
							<c:otherwise>
								<input type="text" readonly="readonly" size="25" id="startDate_da" disabled="disabled"/>
								<img src="jscalendar-1.0/img.gif" id="startDate_trigger"/>
							</c:otherwise>
						</c:choose>
					</td>
				</tr>
				<tr>
					<td>
						<html:checkbox property="endDatePresent" styleId="endDatePresent" onclick="setSchedDate(this, 'endDate_if', 'endDate_da');setForceGradeAllowed()"/>
						<b><fmt:message key="AssignmentEditorPolicy.End.Label"/></b>
					</td>
					<td>
						<html:hidden property="endDate" styleId="endDate_if"/>
						<input type="text" readonly="true" size="25" id="endDate_da"/>
						<img src="jscalendar-1.0/img.gif" id="endDate_trigger"
							onclick="calOnClick(this, 'endDate_if', 'endDate_da', 'endDatePresent', 'true');" />
						<a href="javascript:clearClicked('endDate_if', 'endDate_da', 'endDatePresent')"><fmt:message key="AssignmentEditorPolicy.Clear.Label"/></a>
					</td>
					<td>
						<%-- hide this checkbox for this version, because the feature is disabled --%>
						<html:checkbox property="forceGrade" styleId="forceGrade" style="display:none"/>
						
						<%-- 
						<fmt:message key="AssignmentEditorPolicy.ForceGradeActiveAssignments.Label"/> 
						--%>
					</td>
				</tr>
				<tr>
					<td colspan="3">
					<%--
						<fmt:message key="AssignmentEditorPolicy.ForceGradeActiveAssignmentsDescription.Label"/>					
					--%>
					</td>
				</tr>
			</table>
		</td>
	</tr>

	<tr>
		<td></td>
		<td colspan="4">
			<b><fmt:message key="AssignmentEditorPolicy.Visibility.Label"/></b>
		</td>
	</tr>

	<tr class="sub_part">
		<td></td>
		<td colspan="4">
			<html:checkbox property="visible"/>
			<b><fmt:message key="AssignmentEditorPolicy.Visible.Label"/></b> &nbsp;&nbsp;&nbsp; <fmt:message key="AssignmentEditorPolicy.AssignmentIsVisibleToStudents.Label"/>
			
		</td>

	</tr>
		<tr class="head">
		<th colspan="5">
			<fmt:message key="AssignmentEditorPolicy.LockdownBrowser.Header.Label"/>
		</th>
	</tr>
	<logic:equal name="AssignmentEditForm" property="showLockdownPolicy" value="true">
	<tr>
		<td></td>
		<td colspan="5">
			<html:checkbox property="useLockdown" styleId="useLockdown"/>
			<fmt:message key="AssignmentEditorPolicy.LockdownBrowser.UseLockdown.Label"/>
		</td>
	</tr>
	<%-- <tr>
		<td/>
		<td colspan="5">
			
			<html:select property="lockdownCalculator">
						<html:option value="0"><fmt:message key="AssignmentEditorPolicy.LockdownBrowser.Calculator.0.Option"/></html:option>
						<html:option value="1"><fmt:message key="AssignmentEditorPolicy.LockdownBrowser.Calculator.1.Option"/></html:option>
						<html:option value="2"><fmt:message key="AssignmentEditorPolicy.LockdownBrowser.Calculator.2.Option"/></html:option>
			</html:select>
			<fmt:message key="AssignmentEditorPolicy.LockdownBrowser.Calculator.Label"/>
		</td>
	</tr>
	 --%> 
	 </logic:equal>
	 <logic:notEqual name="AssignmentEditForm" property="showLockdownPolicy" value="true">
	 	<tr>
		<td></td>
		<td colspan="5">
			<fmt:message key="AssignmentEditorPolicy.LockdownBrowser.UnavailableBlackboardWS.Label"/>
		</td>
	</tr>
	 </logic:notEqual>
	 
	<tr class="head">
		<th colspan="5">
			<fmt:message key="AssignmentEditorPolicy.IpRestrictions.Header.Label"/>
		</th>
	</tr>
	<tr>
		<td colspan="6">
			<fmt:message key="AssignmentEditorPolicy.IpRestrictions.Label"/>
			
		</td>
	</tr>
	<tr>
		<td>
			<fmt:message key="AssignmentEditorPolicy.IpRestrictions.SystemGroups.Label"/>
		</td>
		<td colspan="5">
			<table id="groups">
			</table>
		</td>
	</tr>	
	<tr>
		<td>
			<p><fmt:message key="AssignmentEditorPolicy.IpRestrictions.CustomRanges.Label"/></p>
			<p>
			<%
  String ipAddress=request.getRemoteAddr();
%>
			<fmt:message key="AssignmentEditorPolicy.IpRestrictions.YourIp.Label">
				<fmt:param>
					<%=ipAddress %>
				</fmt:param>
			</fmt:message>
			</p>
		</td>
		<td colspan="5" valign="top">
		

		<textarea id="customGroups" rows="7" cols="30"></textarea>
	
		<html:hidden property="systemGroups" styleClass="systemGroups"/>
			<html:hidden property="ipRestrictions" styleClass="assignmentGroups"/>
			
			
		</td>
	</tr>
	
</table>

<script>
	calInit("startDate_if", "startDate_da");
	calInit("endDate_if", "endDate_da");
	calInit("restrictDate_if", "restrictDate_da");
</script>
