<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" language="java"%>
<jsp:directive.page import="com.maplesoft.mapleta.useradmin.Constants" />

<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>

<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>

<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html"%>

<%@ taglib uri="http://displaytag.sf.net" prefix="display"%>

<%@ taglib uri="http://jakarta.apache.org/struts/tags-bean"

	prefix="bean"%>

<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles"%>

<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>



<fmt:bundle

	basename="com.maplesoft.mapleta.application.ApplicationResources">



	<c:set var="DELETE_FILTER_ALL"

		value="<%=Integer.valueOf(com.maplesoft.mapleta.useradmin.Constants.USER_SEARCH_DELETED_FILTER.ALL.ordinal())%>"></c:set>

	<c:set var="DELETE_FILTER_ACTIVE"

		value="<%=Integer.valueOf(com.maplesoft.mapleta.useradmin.Constants.USER_SEARCH_DELETED_FILTER.ACTIVE.ordinal())%>"></c:set>

	<c:set var="DELETE_FILTER_DELETE"

		value="<%=Integer.valueOf(com.maplesoft.mapleta.useradmin.Constants.USER_SEARCH_DELETED_FILTER.DELETE.ordinal())%>"></c:set>



	<a href="#" onClick="toggleItem('search'); this.blur(); return false;">

		<span class="toggle"> <img

				src="modules/configureClasses/images/closeDirIcon.gif" border="0"

				id="searchTwisty"> <fmt:bundle

				basename="com.maplesoft.mapleta.application.ApplicationResources">

				<fmt:message key="UserAdmin.search.panel.label"/>

			</fmt:bundle>

		</span>

	</a>



	<div class="search" id="searchTable">

		<tiles:insert definition=".useradmin.search" flush="false" />

	</div>

	<script>initTwisty();</script>

	

	<br />

	

	<c:choose>

		<c:when

			test="${not empty UserAdmin && UserAdmin.deletedFilter == DELETE_FILTER_ACTIVE}">

			<c:set var="userTypeMessageKey"

				value="UserAdmin.usersInSystem.active.msg"></c:set>

			<c:set var="deleteRestoreMsg"

				value="UserAdmin.usersInSystem.delete.button.label"></c:set>

			<c:set var="dispatch"

				value="<%=com.maplesoft.mapleta.useradmin.Constants.DISPATCH_LISTSELECTIONTODELETE%>"></c:set>

		</c:when>

		<c:when

			test="${not empty UserAdmin && UserAdmin.deletedFilter == DELETE_FILTER_DELETE}">

			<c:set var="userTypeMessageKey"

				value="UserAdmin.usersInSystem.delete.msg"></c:set>

			<c:set var="deleteRestoreMsg"

				value="UserAdmin.usersInSystem.restore.button.label"></c:set>

			<c:set var="dispatch"

				value="<%=com.maplesoft.mapleta.useradmin.Constants.DISPATCH_LISTSELECTIONTORESTORE%>"></c:set>

		</c:when>

		<c:otherwise>

			<c:set var="userTypeMessageKey"

				value="UserAdmin.usersInSystem.all.msg"></c:set>

			<c:set var="dispatch"

				value="<%=com.maplesoft.mapleta.useradmin.Constants.DISPATCH_UNSPECIFIED%>"></c:set>

		</c:otherwise>

	</c:choose>



	<c:if test="${not empty deleteRestoreMsg}">

		<bean:define id="restoreDelete" toScope="page">

			<input type="checkbox" onclick="selectAllItems(this);" />&nbsp;<fmt:message

				key="${deleteRestoreMsg}" />

		</bean:define>

	</c:if>



	<c:choose>

		<c:when test="${fn:length(pageModel.userData) > 0}">

			<br />

			<em class="title"><fmt:message key="${userTypeMessageKey}" />

			</em>

			<br />



			<html:form action="/UserManager" method="post">

				<c:if

					test="${(not empty deleteRestoreMsg) and (fn:length(pageModel.userData) > 0)}">

					<br />

					<html:submit styleClass="button">

						<fmt:message key="${deleteRestoreMsg}" />

					</html:submit>

				</c:if>



				<html:hidden property="dispatch" value="${dispatch}" />



				<display:table id="row" name="${pageModel.userData}" defaultsort="3"

					requestURI="/useradmin/UserManager.do" pagesize="${pageLimit}" class="simple"

					sort="list"

					export="true">

					<%@ include file="/WEB-INF/jsp/displaytag_defaultProperties.jsp" %>

					<display:setProperty name="export.csv.filename" value="students.csv" />

					<display:setProperty name="paging.banner.placement" value="bottom" />

					<display:setProperty name="basic.msg.empty_list" value="<fmt:message key='UserAdmin.search.panel.label'/>" />



					<c:if test="${not empty deleteRestoreMsg}">

						<display:column title="${restoreDelete}" media="html">

							<html:multibox property="selectedItems" value="${row.id}" />

						</display:column>

						<display:setProperty name="defaultsort" value="4" />

					</c:if>



					<display:column sortProperty="uid" titleKey="UserAdmin.uid.label" sortable="true" media="html" >

						<html:link action="/UserInfo.do?uid=${row.uid}">${row.uid}</html:link>

					</display:column>

					<display:column property="uid" titleKey="UserAdmin.uid.label" sortable="true" media="csv" />

					<display:column property="sn" sortable="true" sortProperty="lastNameSortKey"

						titleKey="UserAdmin.lastname.label" media="html csv" />

					<display:column property="givenName" sortable="true" sortProperty="givenNameSortKey"

						titleKey="UserAdmin.firstname.label" />

					<display:column property="email" sortable="true"

						titleKey="UserAdmin.email.label" />

					<display:column property="studentID" sortable="true"

						titleKey="UserAdmin.studentID.label" />

				</display:table>

				<c:if

					test="${(not empty deleteRestoreMsg) and (fn:length(pageModel.userData) > 0)}">

					<br />

					<br />

					<html:submit styleClass="button">

						<fmt:message key="${deleteRestoreMsg}" />

					</html:submit>

				</c:if>

			</html:form>

		</c:when>

		<c:otherwise>

			<br />

			<em class="title"><fmt:message key="UserAdmin.search.no.records.found.msg" />

			</em>

			<br />

		</c:otherwise>

	</c:choose>

</fmt:bundle>

