<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" language="java"%>
<%@page import="com.maplesoft.mapleta.gbk.Constants"%>
<%@ page import="com.maplesoft.mapleta.gateway.GatewayService"%>

<%@ taglib uri="http://struts.apache.org/tags-bean" prefix="bean" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html" %>
<%@ taglib uri="http://struts.apache.org/tags-logic" prefix="logic" %>
<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>

<tiles:useAttribute name="gradesTable" ignore="true"/>

<c:set var="module"><%= request.getContextPath() %></c:set>
<c:set var="NUMERIC" value="<%= new Integer(Constants.NUMERIC_CODE) %>" scope="page"/>
<c:set var="LETTER" value="<%= new Integer(Constants.LETTER_CODE) %>" scope="page"/>
<c:set var="PERCENTAGE" value="<%= new Integer(Constants.PERCENTAGE_CODE) %>" scope="page"/>
<c:set var="IN_PROGRESS" value="<%= Constants.ACTIVE_ASGN_CODE %>" scope="page"/>

<c:set var="SORT_SN"><%= Constants.SORT_SN %></c:set>
<c:set var="SORT_GIVENNAME"><%= Constants.SORT_GIVENNAME %></c:set>
<c:set var="SORT_MI"><%= Constants.SORT_MI %></c:set>
<c:set var="SORT_LOGIN"><%= Constants.SORT_LOGIN %></c:set>
<c:set var="SORT_EMAIL"><%= Constants.SORT_EMAIL %></c:set>
<c:set var="SORT_STUDENTID"><%= Constants.SORT_STUDENTID %></c:set>
<c:set var="SORT_TOTAL"><%= Constants.SORT_TOTAL %></c:set>
<c:set var="SORT_TOTAL_DESC"><%= Constants.SORT_TOTAL_DESC %></c:set>
<c:set var="SORT_NAME"><%= Constants.SORT_NAME %></c:set>
<c:set var="SORT_NAME_DESC"><%= Constants.SORT_NAME_DESC %></c:set>
<c:set var="SORT_GRADE"><%= Constants.SORT_GRADE %></c:set>
<c:set var="SORT_GRADE_DESC"><%= Constants.SORT_GRADE_DESC %></c:set>
<c:set var="SORT_TOTAL"><%= Constants.SORT_TOTAL %></c:set>
<c:set var="SORT_TOTAL_DESC"><%= Constants.SORT_TOTAL_DESC %></c:set>
<c:set var="SORT_START"><%= Constants.SORT_START %></c:set>
<c:set var="SORT_START_DESC"><%= Constants.SORT_START_DESC %></c:set>
<c:set var="SORT_END"><%= Constants.SORT_END %></c:set>
<c:set var="SORT_END_DESC"><%= Constants.SORT_END_DESC %></c:set>
<c:set var="SORT_ATTEMPTS"><%= Constants.SORT_ATTEMPTS %></c:set>
<c:set var="SORT_ATTEMPTS_DESC"><%= Constants.SORT_ATTEMPTS_DESC %></c:set>
<c:set var="SORT_DURATION"><%= Constants.SORT_DURATION %></c:set>
<c:set var="SORT_DURATION_DESC"><%= Constants.SORT_DURATION_DESC %></c:set>
<c:set var="AVG"><%= Constants.AVG_CODE %></c:set>

<tiles:useAttribute name="malformed" ignore="true"/>
<tiles:useAttribute name="unregistered" ignore="true"/>

<script src="<%=GatewayService.getServerURL()%>modules/scripts/repository.js"></script>
<link rel="stylesheet" type="text/css" href="<%=GatewayService.getServerURL()%>modules/skin/css/gbk.css">

<fmt:setBundle basename="com.maplesoft.mapleta.application.ApplicationResources" scope="request"/>
<em class="divider"><fmt:message key="label.import.preview"/></em>
<br/>	

<logic:messagesPresent>
<html:messages id="msg" message="false">
	<span class="errorStyle1"><c:out value='${msg}' escapeXml="false"/></span>
	<br>
</html:messages>
</logic:messagesPresent>
<br/>

<script>
function saveExternal(_action) {
	var form = document.forms['viewSearchForm'];
	var action = '<%= request.getContextPath() %>/gradebook/' + _action + '.do'

	form.action= action;
	form.submit();
}
</script>	

<c:if test="${fn:length(malformed) > 0 || fn:length(gradesTable.unregisteredUsers) > 0}">
	<fmt:message key="msg.import.badlines">
		<fmt:param>${fn:length(malformed)+fn:length(gradesTable.unregisteredUsers)}</fmt:param>
	</fmt:message>
	<a href="#" onclick="openWindow('<%=request.getContextPath()%>/gradebook/ViewMalformed.do',null,'height=400,width=800,status=yes,toolbar=no,menubar=no,location=no'); return false;">View</a>
	<br/><br/>
</c:if>

<input type="button" value="<fmt:message key='label.import.save'/>" onclick="javascript:document.location.href='<%=request.getContextPath()%>/gradebook/SaveCSV.do';" class="button" title="<fmt:message key='msg.import.save'/>"/>

<c:set var="total" value="0"/>
<c:set var="total">${total + 1}</c:set>

<!-- ** put the Labels onto the screen ** -->
<tiles:insert definition=".gbk.page.labels">
	<tiles:put name="gradesTable" beanName="gradesTable"/>
</tiles:insert>

<!-- ** Start the grade table ** -->

<table class="gradesTable" cellpadding="0" cellspacing="0">
	<thead>
	
	<!-- ** Show the assignment headers ** -->
	
		<tr class="asgnHeader">
			<c:if test="${viewSearchForm.showExtraData || viewSearchForm.showClassName}"><td class="invisible">&nbsp;</td></c:if>
			<c:if test="${viewSearchForm.showUid}"><td class="invisible"></td></c:if>
			<c:if test="${viewSearchForm.showLastName}"><td class="invisible"></td></c:if>
			<c:if test="${viewSearchForm.showMi}"><td class="invisible"></td></c:if>
			<c:if test="${viewSearchForm.showGivenName}"><td class="invisible"></td></c:if>
			<c:if test="${viewSearchForm.showEmail}"><td class="invisible"></td></c:if>
			<c:if test="${viewSearchForm.showStudentId}"><td class="invisible"></td></c:if>

<c:forEach var="header1" items="${gradesTable.headers}">
			<td class="gradeColumn yellow">
				<span class="header gradeColumn" title="${header1.name}">
					${header1.longName}
				</span>
			</td>

</c:forEach>
			<c:if test="${not viewSearchForm.allResultType}"><td></td></c:if>			
		</tr>

	<!-- ** Show the user and grade headers ** -->
	
		<tr class="header">
		<c:if test="${viewSearchForm.showExtraData && not viewSearchForm.showClassName}">
			<td>&nbsp;</td>
		</c:if>

			<!-- ** user data headers ** -->
<tiles:insert definition=".gbk.common.userheaders"/>

		<!-- ** grade headers ** -->
	<c:forEach var="header1" items="${gradesTable.headers}" varStatus="c">
			<c:set var="id">${header1.id}</c:set>
			<c:choose>
				<c:when test="${(viewSearchForm.sort eq SORT_GRADE || viewSearchForm.sort eq SORT_GRADE_DESC 
				|| viewSearchForm.sort eq SORT_START || viewSearchForm.sort eq SORT_START_DESC 
				|| viewSearchForm.sort eq SORT_END || viewSearchForm.sort eq SORT_END_DESC
				|| viewSearchForm.sort eq SORT_ATTEMPTS || viewSearchForm.sort eq SORT_ATTEMPTS_DESC 
				|| viewSearchForm.sort eq SORT_DURATION || viewSearchForm.sort eq SORT_DURATION_DESC)
				&& viewSearchForm.sortId == id}">


					<td class="borderLeft gradeColumn sorted">
<table class="gradeData" cellpadding="0" cellspacing="0">					
	<tr>
		<c:choose>
			<c:when test="${viewSearchForm.sort eq SORT_GRADE && viewSearchForm.sortId == id}">
				<td class="grade gradeDataTitle sorted"><a class="sort sorted" href="javascript:sortGrade('${SORT_GRADE_DESC}','${header1.id}')"><fmt:message key="label.grade"/></a></td>				
			</c:when>
			<c:when test="${viewSearchForm.sort eq SORT_GRADE_DESC && viewSearchForm.sortId == id}">
				<td class="grade gradeDataTitle sorted"><a class="sort sorted" href="javascript:sortGrade('${SORT_GRADE}','${header1.id}')"><fmt:message key="label.grade"/></a></td>				
			</c:when>
			<c:otherwise>
				<td class="grade gradeDataTitle"><a class="sort" href="javascript:sortGrade('${SORT_GRADE}','${header1.id}')"><fmt:message key="label.grade"/></a></td>				
			</c:otherwise>
		</c:choose>
			<tiles:insert definition=".gbk.common.gradeDataHeader">
				<tiles:put name="id" value="${header1.id}"/>
			</tiles:insert>
	</tr>
</table>
					</td>
				</c:when>
				<c:otherwise>
					<td class="borderLeft gradeColumn">
<table class="gradeData" cellpadding="0" cellspacing="0">					
	<tr>
			<tiles:insert definition=".gbk.common.gradeDataHeader">
				<tiles:put name="id" value="${header1.id}"/>
			</tiles:insert>
		<c:choose>
			<c:when test="${viewSearchForm.sort eq SORT_GRADE && viewSearchForm.sortId == id}">
				<td class="grade gradeDataTitle sorted"><a class="sort sorted" href="javascript:sortGrade('${SORT_GRADE_DESC}','${header1.id}')"><fmt:message key="label.grade"/></a></td>				
			</c:when>
			<c:when test="${viewSearchForm.sort eq SORT_GRADE_DESC && viewSearchForm.sortId == id}">
				<td class="grade gradeDataTitle sorted"><a class="sort sorted" href="javascript:sortGrade('${SORT_GRADE}','${header1.id}')"><fmt:message key="label.grade"/></a></td>				
			</c:when>
			<c:otherwise>
				<td class="grade gradeDataTitle"><a class="sort" href="javascript:sortGrade('${SORT_GRADE}','${header1.id}')"><fmt:message key="label.grade"/></a></td>				
			</c:otherwise>
		</c:choose>
	</tr>
</table>
					</td>
				</c:otherwise>
			</c:choose>
			
			
	</c:forEach>
		<c:if test="${not viewSearchForm.allResultType}">
			<!-- ** total header ** -->
			<c:choose>
				<c:when test="${viewSearchForm.sort eq SORT_TOTAL}">
					<td class="borderLeft total totalHeader sorted"><a class="sort sorted" href="javascript:sort('<%= Constants.SORT_TOTAL_DESC %>')"><fmt:message key="label.total"/></a></td>
				</c:when>
				<c:when test="${viewSearchForm.sort eq SORT_TOTAL_DESC}">
					<td class="total totalHeader sorted"><a class="sort sorted" href="javascript:sort('<%= Constants.SORT_TOTAL %>')"><fmt:message key="label.total"/></a></td>
				</c:when>
				<c:otherwise>
					<td class="total totalHeader"><a class="sort" href="javascript:sort('<%= Constants.SORT_TOTAL %>')"><fmt:message key="label.total"/></a></td>
				</c:otherwise>
			</c:choose>
		</c:if>
		</tr>		
	</thead>
	<tbody>

	<!-- ** Extra data headers ** -->

<c:if test="${viewSearchForm.showExtraData}">
	<tiles:insert definition=".gbk.common.extraData">
		<tiles:put name="gradesTable" beanName="gradesTable"/>
		<tiles:put name="preview" value="true"/>
	</tiles:insert>
</c:if>

<c:set var="lastId" value="0"/>
<c:forEach var="gradeLine" items="${gradesTable.gradeLines}" varStatus="c">
	<c:set var="maxAttempts">${gradeLine.maxAttempts}</c:set>
	<c:set var="rowClass">
		<c:choose>
			<c:when test="${c.count mod 2 == 0}">even</c:when>
			<c:otherwise>odd</c:otherwise>
		</c:choose>
	</c:set>
		<tr class="${rowClass} userRowHover">
	<c:choose>
		<c:when test="${viewSearchForm.showClassName}"><td class="top className"><span class="className">${gradeLine.className}</span></td></c:when>	
		<c:when test="${viewSearchForm.showExtraData}"><td></td></c:when>
	</c:choose>

	<c:choose>
		<c:when test="${lastId != gradeLine.user.id}">
			<c:if test="${viewSearchForm.showUid}"><td class="top userInfo"><span class="block userLink">${gradeLine.user.uid}</span></td></c:if>
			<c:if test="${viewSearchForm.showLastName}"><td class="top userInfo"><span class="block userLink">${gradeLine.user.sn}</span></td></c:if>
			<c:if test="${viewSearchForm.showMi}"><td class="top userInfo"><span class="block userLink">${gradeLine.user.mi}</span></td></c:if>
			<c:if test="${viewSearchForm.showGivenName}"><td class="top userInfo"><span class="block userLink">${gradeLine.user.givenName}</span></td></c:if>
			<c:if test="${viewSearchForm.showEmail}"><td class="top userInfo"><span class="block userLink">${gradeLine.user.email}</span></td></c:if>
			<c:if test="${viewSearchForm.showStudentId}"><td class="top userInfo"><span class="block userLink">${gradeLine.user.studentID}</span></td></c:if>		
		</c:when>
		<c:otherwise>
			<c:if test="${viewSearchForm.showUid}"><td class="top userInfo"></td></c:if>
			<c:if test="${viewSearchForm.showLastName}"><td class="top userInfo"></td></c:if>
			<c:if test="${viewSearchForm.showMi}"><td class="top userInfo"></td></c:if>
			<c:if test="${viewSearchForm.showGivenName}"><td class="top userInfo"></td></c:if>
			<c:if test="${viewSearchForm.showEmail}"><td class="top userInfo"></td></c:if>
			<c:if test="${viewSearchForm.showStudentId}"><td class="top userInfo"></td></c:if>		
		</c:otherwise>
	</c:choose>
	
		<c:forEach var="gradeWrapper" items="${gradeLine.grades}" varStatus="c">
			<c:set var="attempts">${fn:length(gradeWrapper.grades)}</c:set>
			<c:set var="attempt">0</c:set>

			<td class="borderLeft" style="position: relative;">			

			<c:forEach var="grade" items="${gradeWrapper.grades}">
			
	
<table class="gradeData" cellpadding="0" cellspacing="0">					
	<tr>

				<c:choose>			
					<c:when test="${ viewSearchForm.showGradeData && not grade.emptyGrade }">
						<tiles:insert definition=".gbk.common.gradeData">
							<tiles:put name="grade" beanName="grade"/>
							<tiles:put name="attempt" value="${attempt}"/>
							<tiles:put name="attempts" value="${attempts}"/>
						</tiles:insert>
					</c:when>
					<c:when test="${ viewSearchForm.showGradeData }">
					</c:when>
				</c:choose>		

		<c:choose>
			<c:when test="${grade.emptyGrade}"><td class="grade ${styleClass}"></c:when>
			<c:otherwise><td class="grade ${styleClass}" title="${grade.grade}/${grade.total}"></c:otherwise>
		</c:choose>
		
				<c:choose>
					<c:when test="${grade.emptyGrade}">
						<fmt:message key="label.decorator.number.empty"/>
					</c:when>
					<c:otherwise>
						${grade}
					</c:otherwise>
				</c:choose>
		</td>
				
	</tr>
</table>

			</c:forEach>
			
			</td>			

		</c:forEach>




	<c:if test="${not viewSearchForm.allResultType}">		
		<c:choose>
			<c:when test="${grade.emptyGrade}"><td class="top total"></c:when>
			<c:otherwise><td class="top total" title="${gradeLine.total.grade}/${gradeLine.total.total}"></c:otherwise>
		</c:choose>


		<c:choose>
			<c:when test="${gradeLine.total.emptyGrade}">
				<fmt:message key="label.decorator.number.empty"/>
			</c:when>
			<c:when test="${viewSearchForm.gradingStyle == PERCENTAGE}">
				${gradeLine.total.percent}
			</c:when>
			<c:when test="${viewSearchForm.gradingStyle == LETTER}">
				${gradeLine.total.letter}
			</c:when>
			<c:otherwise>
				<fmt:formatNumber maxFractionDigits="2" value="${gradeLine.total.grade}"/>
				</td>
			</c:otherwise>
		</c:choose>
	</c:if>
		</tr>
<c:set var="lastId">${gradeLine.user.id}</c:set>
</c:forEach>
	</tbody>

</table>

<!-- ** put the Labels onto the screen ** -->
<tiles:insert definition=".gbk.page.labels">
	<tiles:put name="gradesTable" beanName="gradesTable"/>
</tiles:insert>


