<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" language="java"%>

<%@ taglib uri="http://struts.apache.org/tags-bean" prefix="bean"%>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html"%>
<%@ taglib uri="http://struts.apache.org/tags-logic" prefix="logic"%>
<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="http://displaytag.sf.net" prefix="display"%>


<script>
function toggleCol(chkbx, name) {
	var elems = document.getElementsByName(name);

	for( i=0; i<elems.length; i++ ) {
		var elem = elems[i];
		if( !chkbx.checked ) {
			elem.className += " hidden";
		}
		else {
			elem.className = elem.className.replace(" hidden", "");
		}
	}
}
</script>

<style>
	.hidden {
		display:none;
	}
</style>

<tiles:useAttribute name="responses" ignore="true"/>

<fmt:bundle basename="com.maplesoft.mapleta.gradebook.struts.app.ApplicationResources">

<div style="padding:15px;">

<input type="button" class="button" onclick="window.close()" value='<fmt:message key="label.close"/>'/>
<input type="button" class="button" value='<fmt:message key="label.print"/>' onClick="window.print()" />

<br/><br/>
<table cellpadding="0" cellspacing="0">
	<tr>
		<td><input type="checkbox" onchange="toggleCol(this, 'firstName')" checked="checked"/></td><td><fmt:message key="label.firstName"/></td>
		<td><input type="checkbox" onchange="toggleCol(this, 'mi')" checked="checked"/></td><td><fmt:message key="label.mi"/></td>
		<td><input type="checkbox" onchange="toggleCol(this, 'lastName')" checked="checked"/></td><td><fmt:message key="label.lastName"/></td>
	</tr>
	<tr>
		<td><input type="checkbox" onchange="toggleCol(this, 'uid')" checked="checked"/></td><td><fmt:message key="label.uid"/></td>
		<td><input type="checkbox" onchange="toggleCol(this, 'studentId')" checked="checked"/></td><td><fmt:message key="label.studentId"/></td>
	</tr>
</table>	
<table cellpadding="0" cellspacing="0" class="simple">
	<thead>
	<tr>
		<th name="uid" class="uid"><fmt:message key="label.uid"/></th>
		<th name="studentId" class="studentId"><fmt:message key="label.studentId"/></th>
		<th name="firstName" class="firstName"><fmt:message key="label.firstName"/></th>
		<th name="mi" class="mi"><fmt:message key="label.mi"/></th>
		<th name="lastName" class="lastName"><fmt:message key="label.lastName"/></th>
		<th name="response">Response</th>
	</tr>
	</thead>
<c:forEach var="row" items="${responses}" varStatus="c">
	<c:choose>
		<c:when test="${c.count mod 2 == 0}"><c:set var="styleClass" value="even"/></c:when>
		<c:otherwise><c:set var="styleClass" value="odd"/></c:otherwise>
	</c:choose>
	<tr class="${styleClass}">
		<td name="uid" class="uid">${row.user.uid}</td>
		<td name="studentId" class="studentId">${row.user.studentId}</td>
		<td name="firstName" class="firstName">${row.user.givenName}</td>
		<td name="mi" class="mi">${row.user.mi}</td>
		<td name="lastName" class="lastName">${row.user.sn}</td>
		<td name="response" class="response">${row.questionDetail.response}</td>
		<tiles:insert definition=".gbk.details.instructor.itemdetail.page" flush="false">
			<tiles:put name="itemDetail" beanName="row" beanProperty="questionDetail" />
		</tiles:insert>
	</tr>
</c:forEach>
</table>

</div>

</fmt:bundle>

