/*
 * Decompiled with CFR 0.152.
 */
package applets.sliderBall;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;

public class SliderBall
extends Applet {
    private static final Color RULER_COLOR = new Color(202, 182, 110);
    private static final Color RULER_WHISKER_COLOR = Color.black;
    private static final int RULER_WIDTH = 20;
    private static final int RULER_MAX = 45;
    private static final int BALL_SIZE = 20;
    private static final int LEFT_BALL_MARGIN = 30;
    private int leftBallHeight = 50;
    private static final int RIGHT_BALL_MARGIN = 60;
    private int rightBallHeight = 80;
    private boolean draggingRightBall = false;
    private int draggingRightBallOffset = 0;
    private static final Color MARKER_COLOR = Color.green;
    private static final int MARKER_WIDTH = 10;
    private static final int MARKER_HEIGHT = 4;
    private Image offscreen;
    private Image rightBallImage;
    private Image leftBallImage;
    private boolean locked;
    private static final Color MARKER_BORDER_COLOR = Color.black;

    public int fromPixels(int y) {
        double a = 45 * (this.size().height - y - 10);
        double b = this.size().height;
        return (int)(a / b + 0.5);
    }

    public String getResponse() {
        return "" + this.fromPixels(this.rightBallHeight);
    }

    public void init() {
        this.readParameters();
        this.setBackground(Color.white);
        this.offscreen = this.createImage(this.size().width, this.size().height);
        this.rightBallImage = this.getImage(this.getCodeBase(), "applets/sliderBall/red_ball.gif");
        this.leftBallImage = this.getImage(this.getCodeBase(), "applets/sliderBall/purple_ball.gif");
    }

    private boolean isInRightBall(int x, int y) {
        return x > 60 && x < 80 && y > this.rightBallHeight && y < this.rightBallHeight + 20;
    }

    public boolean mouseDown(Event e, int x, int y) {
        if (!this.locked && this.isInRightBall(x, y)) {
            this.draggingRightBall = true;
            this.draggingRightBallOffset = y - this.rightBallHeight;
        }
        return true;
    }

    public boolean mouseDrag(Event e, int x, int y) {
        if (this.draggingRightBall) {
            this.rightBallHeight = y - this.draggingRightBallOffset;
            this.repaint();
        }
        return true;
    }

    public boolean mouseExit(Event e, int x, int y) {
        return this.mouseUp(e, x, y);
    }

    public boolean mouseUp(Event e, int x, int y) {
        this.draggingRightBall = false;
        return true;
    }

    public void paint(Graphics g) {
        Graphics gr = this.offscreen.getGraphics();
        gr.setColor(this.getBackground());
        gr.fillRect(0, 0, this.size().width, this.size().height);
        this.paintRuler(gr);
        this.paintLeftBall(gr);
        this.paintRightBall(gr);
        g.drawImage(this.offscreen, 0, 0, this);
    }

    private void paintLeftBall(Graphics g) {
        g.drawImage(this.leftBallImage, 30, this.leftBallHeight, 20, 20, this);
        this.paintMarker(g, this.leftBallHeight + 10);
    }

    private void paintMarker(Graphics g, int y) {
        Polygon p = new Polygon();
        p.addPoint(10, y - 4);
        p.addPoint(10, y + 4);
        p.addPoint(20, y);
        g.setColor(MARKER_COLOR);
        g.fillPolygon(p);
        g.setColor(MARKER_BORDER_COLOR);
        g.drawPolygon(p);
    }

    private void paintRightBall(Graphics g) {
        g.drawImage(this.rightBallImage, 60, this.rightBallHeight, 20, 20, this);
        this.paintMarker(g, this.rightBallHeight + 10);
    }

    private void paintRuler(Graphics g) {
        g.setColor(RULER_COLOR);
        g.fillRect(0, 0, 21, this.size().height);
        g.setColor(RULER_WHISKER_COLOR);
        double step = (double)this.size().height / 45.0;
        int i = 1;
        while (i <= 45) {
            int rwidth;
            int h = (int)((double)this.size().height - (double)i * step);
            if (i % 10 == 0) {
                Font f = new Font("Helvetica", 0, 8);
                FontMetrics fm = g.getFontMetrics(f);
                int fheight = fm.getAscent();
                g.setFont(f);
                g.drawString("" + i, 22, h + fheight / 2);
                rwidth = 20;
            } else {
                rwidth = i % 5 == 0 ? 10 : 5;
            }
            g.drawLine(20 - rwidth, h, 20, h);
            ++i;
        }
    }

    private void readParameters() {
        try {
            this.rightBallHeight = this.toPixels((int)Double.valueOf(this.getParameter("right")).doubleValue());
            this.leftBallHeight = this.toPixels((int)Double.valueOf(this.getParameter("left")).doubleValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String response = this.getParameter("response");
            if (response != null && response.length() > 0) {
                this.rightBallHeight = this.toPixels((int)Double.valueOf(response).doubleValue());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.locked = "true".equals(this.getParameter("locked"));
    }

    private int toPixels(int v) {
        return this.size().height * (45 - v) / 45 - 10;
    }

    public void update(Graphics g) {
        this.paint(g);
    }
}

