/*
 * Decompiled with CFR 0.152.
 */
package applets.grapher;

import applets.grapher.GraphWindow;
import applets.grapher.Parser;
import applets.util.URLEncoder;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.net.MalformedURLException;
import java.net.URL;

public class Graph
extends Applet {
    public void init() {
        String labelString;
        String formulaString;
        double xMin = Double.valueOf(this.getParameter("xMin", "-5"));
        double xMax = Double.valueOf(this.getParameter("xMax", "5"));
        double yMin = Double.valueOf(this.getParameter("yMin", "-5"));
        double yMax = Double.valueOf(this.getParameter("yMax", "5"));
        double numGridLines = Double.valueOf(this.getParameter("gridLines", "10"));
        String p = this.getParameter("xScale");
        double xScale = p == null ? (xMax - xMin) / numGridLines : Double.valueOf(p);
        p = this.getParameter("yScale");
        double yScale = p == null ? (yMax - yMin) / numGridLines : Double.valueOf(p);
        GraphWindow g = new GraphWindow(xMin, xMax, xScale, yMin, yMax, yScale);
        this.setLayout(new BorderLayout());
        this.add("Center", g);
        p = this.getParameter("background");
        if (p != null) {
            try {
                URL u;
                try {
                    u = new URL(URLEncoder.encode(p));
                }
                catch (MalformedURLException e) {
                    u = new URL(this.getDocumentBase(), URLEncoder.encode(p));
                }
                g.setBackground(this.getImage(u));
            }
            catch (MalformedURLException u) {
                // empty catch block
            }
        }
        if ((p = this.getParameter("xfmt")) != null) {
            g.setXFmt(p);
        }
        if ((p = this.getParameter("yfmt")) != null) {
            g.setYFmt(p);
        }
        int i = 1;
        while ((formulaString = this.getParameter("y" + i)) != null) {
            Parser prs = new Parser();
            prs.parse(formulaString);
            g.addFunction(prs);
            ++i;
        }
        int i2 = 1;
        while ((labelString = this.getParameter("label." + i2)) != null) {
            Double dWork = new Double(this.getParameter("label." + i2 + ".x"));
            double x = dWork;
            dWork = new Double(this.getParameter("label." + i2 + ".y"));
            double y = dWork;
            g.addLabel(x, y, labelString);
            ++i2;
        }
    }

    String getParameter(String name, String def) {
        String p = this.getParameter(name);
        return p != null ? p : def;
    }
}

