/*
 * Decompiled with CFR 0.152.
 */
package applets.clickableImage;

import applets.clickableImage.CICImageCanvas;
import applets.util.URLEncoder;
import applets.util.WarningDialog;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Point;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;

public class ClickableImageCreator
extends Applet
implements Runnable {
    static final String TEST_KEY = "clickable.image.response";
    Image image;
    private Button undoButton;
    private Button showAll;
    private Button newButton;
    private Button deleteButton;
    private Button selectButton;
    private Panel topBar;
    private CICImageCanvas imageArea;
    String loadingStatus;
    boolean gotImage = false;
    private Frame holderFrame;

    public boolean action(Event event, Object what) {
        if (event.target == this.newButton) {
            this.imageArea.addRegion();
        } else if (event.target == this.deleteButton) {
            this.imageArea.deleteActiveRegion();
        } else if (event.target == this.selectButton) {
            this.imageArea.selectActiveRegion();
        } else {
            return super.handleEvent(event);
        }
        return true;
    }

    private URL completeURL(String tail) throws MalformedURLException {
        try {
            return new URL(URLEncoder.encode(tail));
        }
        catch (MalformedURLException e) {
            String urlBase = this.getCodeBase().toString();
            int c = urlBase.indexOf(63);
            if (c >= 0) {
                urlBase = urlBase.substring(0, c);
            }
            if ((c = urlBase.lastIndexOf(47)) >= 0) {
                urlBase = urlBase.substring(0, c + 1);
            }
            return new URL(URLEncoder.encode(String.valueOf(urlBase) + tail));
        }
    }

    public void destroy() {
        this.holderFrame.dispose();
        this.holderFrame = null;
    }

    private void dialog(Exception e) {
        this.loadingStatus = "Image could not be loaded.  Check the filename.";
        this.showStatus("Image could not be loaded.  Check the filename.");
        System.out.println("Exception: " + e.toString());
        e.printStackTrace();
        this.popup("There was an error loading the image at:\n\n   " + this.getParameter("imageURL") + "\n\n" + "Please check this URL, and press \"Back\" on the\n" + "web-page to re-enter the address.\n\n" + "More information on this error may be available on your\n" + "browser's Java console.");
    }

    public void doneButtonAction() {
        block7: {
            Vector regions = this.imageArea.getRegions();
            int correct = this.imageArea.getCorrect() + 1;
            if (correct < 1 || correct > regions.size()) {
                this.popup("You must select a region to be the correct answer.");
                return;
            }
            try {
                String urlStr = "dbEdit.AddClickableImage?actionID=accept";
                urlStr = String.valueOf(urlStr) + "&clickable.image.response=" + this.getParameter(TEST_KEY) + "&answer=" + correct + "&imageURL=" + this.getParameter("imageURL") + "&width=" + this.image.getWidth(this) + "&height=" + this.image.getHeight(this);
                int n = 1;
                int i = 0;
                while (i < regions.size()) {
                    Vector v = (Vector)regions.elementAt(i);
                    if (v.size() > 3) {
                        urlStr = String.valueOf(urlStr) + "&region." + n + "=";
                        int j = 0;
                        while (j < v.size() - 1) {
                            Point p1 = (Point)v.elementAt(j);
                            urlStr = String.valueOf(urlStr) + p1.x + "," + p1.y + ",";
                            ++j;
                        }
                        ++n;
                    }
                    ++i;
                }
                urlStr = String.valueOf(urlStr) + "&numberOfRegions=" + (n - 1);
                urlStr = String.valueOf(urlStr) + "&forceReload=" + System.currentTimeMillis();
                if (n > 2) {
                    this.getAppletContext().showDocument(this.completeURL(urlStr), "_self");
                    break block7;
                }
                this.popup("You must draw at least two regions on image.");
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.loadingStatus = "Question update failed.  Press BACK and try again.";
                this.showStatus("Question update failed.  Press BACK and try again.");
            }
        }
    }

    private int getAnswerFromParameters() {
        try {
            return Integer.parseInt(this.getParameter("answer"));
        }
        catch (Exception e) {
            return -1;
        }
    }

    private Vector getRegionsFromParameters() {
        String region;
        Vector regions = new Vector();
        int i = 1;
        while ((region = this.getParameter("region." + i)) != null) {
            StringTokenizer stz = new StringTokenizer(region, ",\n\t ");
            int numPoints = stz.countTokens() / 2;
            Vector<Point> v = new Vector<Point>();
            int j = 0;
            while (j < numPoints) {
                v.addElement(new Point(Integer.parseInt(stz.nextToken()), Integer.parseInt(stz.nextToken())));
                ++j;
            }
            v.addElement((Point)v.elementAt(0));
            regions.addElement(v);
            ++i;
        }
        if (regions.size() == 0) {
            regions.addElement(new Vector());
        }
        return regions;
    }

    public void init() {
        this.holderFrame = new Frame();
        this.loadingStatus = "Loading image...";
        this.showStatus("Loading image...");
        Thread loader = new Thread(this);
        loader.start();
        this.setBackground(Color.white);
        this.setForeground(Color.black);
        this.setFont(new Font("Helvetica", 0, 12));
        this.setLayout(new BorderLayout());
        this.topBar = new Panel();
        this.topBar.setBackground(Color.white);
        this.newButton = new Button("[N]ew Region");
        this.topBar.add(this.newButton);
        this.selectButton = new Button("[S]et Correct");
        this.topBar.add(this.selectButton);
        this.deleteButton = new Button("[D]elete");
        this.topBar.add(this.deleteButton);
        this.add("North", this.topBar);
        this.imageArea = new CICImageCanvas(this.getRegionsFromParameters(), this.getAnswerFromParameters(), this);
        this.add("Center", this.imageArea);
    }

    public boolean keyDown(Event event, int key) {
        switch (key) {
            case 78: 
            case 110: {
                this.imageArea.addRegion();
                return true;
            }
            case 68: 
            case 100: {
                this.imageArea.deleteActiveRegion();
                return true;
            }
            case 83: 
            case 115: {
                this.imageArea.selectActiveRegion();
                return true;
            }
        }
        return super.keyDown(event, key);
    }

    public boolean mouseEnter(Event event, int x, int y) {
        this.showStatus(this.loadingStatus);
        return true;
    }

    private void popup(String message) {
        new WarningDialog(this.holderFrame, message).show();
    }

    public void run() {
        try {
            this.image = this.getImage(this.completeURL(this.getParameter("imageURL")));
            MediaTracker tracker = new MediaTracker(this);
            tracker.addImage(this.image, 0);
            while (tracker.statusID(0, true) == 1) {
                this.showStatus("Loading image...");
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.showStatus("");
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (tracker.isErrorID(0)) {
                throw new Exception("Error loading image...");
            }
            this.gotImage = true;
            this.loadingStatus = "Image loaded...";
            this.showStatus("Image loaded...");
            Image tempImage = this.createImage(this.image.getWidth(this), this.image.getHeight(this));
            tempImage.getGraphics().drawImage(this.image, 0, 0, Color.white, this);
            this.image = tempImage;
            if (this.imageArea != null) {
                this.imageArea.repaint();
            }
        }
        catch (Exception e) {
            this.dialog(e);
        }
    }
}

