/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mapleta.hotfix.installer;

import com.maplesoft.mapleta.hotfix.installer.ClassPathTools;
import com.maplesoft.mapleta.hotfix.installer.HotfixHistoryLogger;
import com.maplesoft.mapleta.hotfix.installer.Installer;
import com.maplesoft.mapleta.hotfix.installer.MapleTADataSource;
import com.maplesoft.mapleta.hotfix.installer.Platform;
import com.maplesoft.mapleta.hotfix.installer.TomcatInstallationManager;
import com.maplesoft.mapleta.hotfix.installer.UpdateLogger;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class MapleTAInstallationManager {
    private static final String postgresDriverRegex = "^postgresql.*.jdbc3.jar$";
    private static final String hotfixLogFolder = "hotfixlog";
    private static final String hotfixLogFilename = "hotfixes.log";
    private TomcatInstallationManager tomcatInstallationManager;
    private String mapleTAInstallationFolder;

    public String getMapleTAInstallationFolder() {
        return this.mapleTAInstallationFolder;
    }

    public String getMapleTAInstallationHotfixHistoryLogPathname() {
        return String.valueOf(this.getMapleTAInstallationFolder()) + File.separator + hotfixLogFolder + File.separator + hotfixLogFilename;
    }

    public MapleTAInstallationManager(TomcatInstallationManager tomcatInstallationManager) throws Exception {
        this.tomcatInstallationManager = tomcatInstallationManager;
        try {
            this._GetMapleTAInstallationFolder();
        }
        catch (Exception ex) {
            throw new Exception("Error while accessing Maple T.A. database, unable to determine Maple T.A. installation folder.", ex);
        }
    }

    private void _GetMapleTAInstallationFolder() throws Exception {
        block13: {
            MapleTADataSource dataSource = this.tomcatInstallationManager.getMapleTADataSource();
            String driver = "org.postgresql.Driver";
            String table = "system_properties";
            String key = "gatewayHomePath";
            String query = String.format("select value from %s where key='%s'", table, key);
            String[] postgresDriverLocations = new String[]{"lib", "server" + File.separator + "lib", "common" + File.separator + "lib", "webapps" + File.separator + Installer.getHotfixDef().getContextName() + File.separator + "WEB-INF" + File.separator + "lib"};
            ArrayList<String> jarFiles = new ArrayList<String>();
            String[] stringArray = postgresDriverLocations;
            int n = postgresDriverLocations.length;
            int n2 = 0;
            while (n2 < n) {
                String postgresDriverLocation = stringArray[n2];
                File locationFile = new File(String.valueOf(this.tomcatInstallationManager.getTomcatFolder()) + File.separator + postgresDriverLocation);
                if (locationFile.isDirectory()) {
                    String[] stringArray2 = locationFile.list();
                    int n3 = stringArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String filename = stringArray2[n4];
                        if (Pattern.matches(postgresDriverRegex, filename)) {
                            jarFiles.add(String.valueOf(locationFile.getAbsolutePath()) + File.separator + filename);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            if (jarFiles.size() > 0) {
                ClassPathTools.AddJarToClassPath((String)jarFiles.get(0));
            } else {
                UpdateLogger.getLogger().Log("Unable to find the postgresql driver jar in the Tomcat installation.");
            }
            try {
                Class.forName(driver);
            }
            catch (Exception ex) {
                throw new Exception(String.format("Unable to load database driver '%s'.", driver));
            }
            Connection connection = DriverManager.getConnection(dataSource.getJdbcUrl(), dataSource.getUser(), dataSource.getPassword());
            Statement statement = connection.createStatement();
            ResultSet results = statement.executeQuery(query);
            try {
                if (results.next()) {
                    String folder = results.getString(1);
                    File file = new File(folder);
                    if (file.isDirectory()) {
                        this.mapleTAInstallationFolder = Platform.NormalizePathSeparators(folder);
                        UpdateLogger.getLogger().Log(String.format("Maple T.A. installation folder: '%s'.", this.mapleTAInstallationFolder));
                        break block13;
                    }
                    throw new Exception(String.format("The Maple T.A. installation folder configured in the Maple T.A. database cannot be found, or is not a directory: '%s'.", folder));
                }
                throw new Exception(String.format("The Maple T.A. installation folder configuration entry was not found in the Maple T.A. database. Query: '%s'.", query));
            }
            finally {
                connection.close();
            }
        }
    }

    public void InitializeHotfixLog() throws Exception {
        String logpath = this.getMapleTAInstallationHotfixHistoryLogPathname();
        File logFile = new File(logpath);
        HotfixHistoryLogger.setLogFilepath(logpath);
        if (logFile.isFile()) {
            if (!logFile.canWrite()) {
                throw new Exception(String.format("We do not have permission to write to the hotfix history log file '%s', unable to log history.", logFile.getAbsolutePath()));
            }
            return;
        }
        if (logFile.exists()) {
            throw new Exception(String.format("Hotfix history log file path '%s' is not a file, unable to log history.", logFile.getAbsolutePath()));
        }
        File logFolderFile = new File(logFile.getParent());
        if (logFolderFile.exists()) {
            if (!logFolderFile.isDirectory()) {
                throw new Exception(String.format("Hotfix history log folder path '%s' is not a directory, unable to log history.", logFolderFile.getAbsolutePath()));
            }
        } else if (!logFolderFile.mkdirs()) {
            throw new Exception(String.format("Unable to create hotfix history log folder '%s', unable to log history.", logFolderFile.getAbsolutePath()));
        }
        HotfixHistoryLogger.getLogger().Log("Initializing hotfix history log.");
        if (!logFile.exists()) {
            throw new Exception(String.format("Error writing to the hotfix history log file '%s', unable to log history.", logFile.getAbsolutePath()));
        }
    }
}

