/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mapleta.hotfix.installer;

import com.maplesoft.mapleta.hotfix.installer.Platform;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowsRegistry {
    public static final int HKEY_CLASSES_ROOT = Integer.MIN_VALUE;
    public static final int HKEY_CURRENT_USER = -2147483647;
    public static final int HKEY_LOCAL_MACHINE = -2147483646;
    public static final int ERROR_SUCCESS = 0;
    public static final int ERROR_FILE_NOT_FOUND = 2;
    public static final int ERROR_ACCESS_DENIED = 5;
    public static final int NATIVE_HANDLE = 0;
    public static final int ERROR_CODE = 1;
    public static final int SUBKEYS_NUMBER = 0;
    public static final int VALUES_NUMBER = 2;
    public static final int MAX_KEY_LENGTH = 3;
    public static final int MAX_VALUE_NAME_LENGTH = 4;
    public static final int DELETE = 65536;
    public static final int KEY_QUERY_VALUE = 1;
    public static final int KEY_SET_VALUE = 2;
    public static final int KEY_CREATE_SUB_KEY = 4;
    public static final int KEY_ENUMERATE_SUB_KEYS = 8;
    public static final int KEY_READ = 131097;
    public static final int KEY_WRITE = 131078;
    public static final int KEY_ALL_ACCESS = 983103;
    private Method windowsRegOpenKey = null;
    private Method windowsRegCloseKey = null;
    private Method windowsRegQueryValueEx = null;
    private Method windowsRegSetValueEx = null;
    private Method windowsRegQueryInfoKey = null;
    private Method windowsRegEnumKeyEx = null;
    private Method windowsRegEnumValue = null;

    public WindowsRegistry() throws WindowsRegistryException {
        if (!Platform.IsWindows()) {
            throw new WindowsRegistryException("Internal error. Attempt to read the registry on a non-Windows platform.");
        }
        this.initialize();
    }

    public int openKey(int key, String subkey) throws WindowsRegistryException {
        return this.openKey(key, subkey, 983103);
    }

    public int openKey(int key, String subkey, int security_mask) throws WindowsRegistryException {
        int[] result;
        block5: {
            result = (int[])this.windowsRegOpenKey.invoke(null, new Integer(key), this.getString(subkey), new Integer(security_mask));
            if (result != null && result[1] == 0) break block5;
            return -1;
        }
        try {
            return result[0];
        }
        catch (InvocationTargetException ex1) {
            throw new WindowsRegistryException(ex1.getMessage());
        }
        catch (IllegalArgumentException ex1) {
            throw new WindowsRegistryException(ex1.getMessage());
        }
        catch (IllegalAccessException ex1) {
            throw new WindowsRegistryException(ex1.getMessage());
        }
    }

    public int closeKey(int key) throws WindowsRegistryException {
        try {
            Integer ret = (Integer)this.windowsRegCloseKey.invoke(null, new Integer(key));
            if (ret != null) {
                return ret;
            }
            return -1;
        }
        catch (InvocationTargetException ex) {
            throw new WindowsRegistryException(ex.getMessage());
        }
        catch (IllegalArgumentException ex) {
            throw new WindowsRegistryException(ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            throw new WindowsRegistryException(ex.getMessage());
        }
    }

    public List<String> listKeys(int key) throws WindowsRegistryException {
        return this.listKeys(key, null);
    }

    public List<String> listKeys(int key, String subkey) throws WindowsRegistryException {
        int handle = -1;
        try {
            int[] info;
            handle = this.openKey(key, subkey, 131097);
            if (handle != -1 && (info = this.getChildInformation(handle)) != null && info[0] != -1) {
                ArrayList<String> ret = new ArrayList<String>();
                int x = 0;
                while (x != info[0]) {
                    String tmp = WindowsRegistry.parseValue(this.enumKeys(handle, x, info[3] + 1));
                    if (tmp != null) {
                        ret.add(tmp);
                    }
                    ++x;
                }
                ArrayList<String> arrayList = ret.isEmpty() ? null : ret;
                return arrayList;
            }
        }
        catch (WindowsRegistryException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WindowsRegistryException(ex.getMessage());
        }
        finally {
            this.closeKey(handle);
        }
        return null;
    }

    public List<String> listValueNames(int key) throws WindowsRegistryException {
        return this.listValueNames(key, null);
    }

    public List<String> listValueNames(int key, String subkey) throws WindowsRegistryException {
        int handle = -1;
        try {
            int[] info;
            handle = this.openKey(key, subkey, 131097);
            if (handle != -1 && (info = this.getChildInformation(handle)) != null && info[0] != -1) {
                ArrayList<String> ret = new ArrayList<String>();
                int x = 0;
                while (x != info[2]) {
                    String tmp = WindowsRegistry.parseValue(this.enumValueName(handle, x, info[4] + 1));
                    if (tmp != null) {
                        ret.add(tmp);
                    }
                    ++x;
                }
                ArrayList<String> arrayList = ret.isEmpty() ? null : ret;
                return arrayList;
            }
        }
        catch (WindowsRegistryException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WindowsRegistryException(ex.getMessage());
        }
        finally {
            this.closeKey(handle);
        }
        return null;
    }

    public String getValue(int key, String valueName) throws WindowsRegistryException {
        return WindowsRegistry.parseValue(this.readValue(key, valueName));
    }

    private byte[] enumValueName(int key, int valueNameIndex, int maxValueNameLength) throws WindowsRegistryException {
        try {
            return (byte[])this.windowsRegEnumValue.invoke(null, new Integer(key), new Integer(valueNameIndex), new Integer(maxValueNameLength));
        }
        catch (InvocationTargetException ex) {
            throw new WindowsRegistryException(ex.getMessage());
        }
        catch (IllegalArgumentException ex) {
            throw new WindowsRegistryException(ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            throw new WindowsRegistryException(ex.getMessage());
        }
    }

    private byte[] enumKeys(int key, int subkeyIndex, int maxKeyNameLength) throws WindowsRegistryException {
        try {
            return (byte[])this.windowsRegEnumKeyEx.invoke(null, new Integer(key), new Integer(subkeyIndex), new Integer(maxKeyNameLength));
        }
        catch (InvocationTargetException ex) {
            throw new WindowsRegistryException(ex.getMessage());
        }
        catch (IllegalArgumentException ex) {
            throw new WindowsRegistryException(ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            throw new WindowsRegistryException(ex.getMessage());
        }
    }

    private int[] getChildInformation(int key) throws WindowsRegistryException {
        try {
            return (int[])this.windowsRegQueryInfoKey.invoke(null, new Integer(key));
        }
        catch (InvocationTargetException ex) {
            throw new WindowsRegistryException(ex.getMessage());
        }
        catch (IllegalArgumentException ex) {
            throw new WindowsRegistryException(ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            throw new WindowsRegistryException(ex.getMessage());
        }
    }

    private byte[] readValue(int key, String valueName) throws WindowsRegistryException {
        try {
            byte[] ret = (byte[])this.windowsRegQueryValueEx.invoke(null, new Integer(key), this.getString(valueName));
            return ret;
        }
        catch (InvocationTargetException ex) {
            throw new WindowsRegistryException(ex.getMessage());
        }
        catch (IllegalArgumentException ex) {
            throw new WindowsRegistryException(ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            throw new WindowsRegistryException(ex.getMessage());
        }
    }

    private byte[] getString(String str) {
        if (str == null) {
            str = "";
        }
        str = String.valueOf(str) + "\u0000";
        return str.getBytes();
    }

    private static String parseValue(byte[] buf) {
        if (buf == null) {
            return null;
        }
        String ret = new String(buf);
        if (ret.charAt(ret.length() - 1) == '\u0000') {
            return ret.substring(0, ret.length() - 1);
        }
        return ret;
    }

    private void initialize() throws WindowsRegistryException {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("java.util.prefs.WindowsPreferences");
            Method[] ms = clazz.getDeclaredMethods();
            if (ms == null) {
                throw new WindowsRegistryException("Unable to access java.util.prefs.WindowsPreferences.");
            }
            int x = 0;
            while (x != ms.length) {
                if (ms[x] != null) {
                    if (ms[x].getName().equals("WindowsRegOpenKey")) {
                        this.windowsRegOpenKey = ms[x];
                        this.windowsRegOpenKey.setAccessible(true);
                    } else if (ms[x].getName().equals("WindowsRegCloseKey")) {
                        this.windowsRegCloseKey = ms[x];
                        this.windowsRegCloseKey.setAccessible(true);
                    } else if (ms[x].getName().equals("WindowsRegQueryValueEx")) {
                        this.windowsRegQueryValueEx = ms[x];
                        this.windowsRegQueryValueEx.setAccessible(true);
                    } else if (ms[x].getName().equals("WindowsRegSetValueEx")) {
                        this.windowsRegSetValueEx = ms[x];
                        this.windowsRegSetValueEx.setAccessible(true);
                    } else if (ms[x].getName().equals("WindowsRegQueryInfoKey")) {
                        this.windowsRegQueryInfoKey = ms[x];
                        this.windowsRegQueryInfoKey.setAccessible(true);
                    } else if (ms[x].getName().equals("WindowsRegEnumKeyEx")) {
                        this.windowsRegEnumKeyEx = ms[x];
                        this.windowsRegEnumKeyEx.setAccessible(true);
                    } else if (ms[x].getName().equals("WindowsRegEnumValue")) {
                        this.windowsRegEnumValue = ms[x];
                        this.windowsRegEnumValue.setAccessible(true);
                    }
                }
                ++x;
            }
        }
        catch (ClassNotFoundException ex) {
            throw new WindowsRegistryException(ex.getMessage());
        }
    }

    public class WindowsRegistryException
    extends Exception {
        public WindowsRegistryException(String message, Throwable cause) {
            super(message, cause);
        }

        public WindowsRegistryException(String message) {
            super(message);
        }
    }
}

