/*
 * Decompiled with CFR 0.152.
 */
package applets.sketching;

import applets.sketching.BufferedSplinePlot;
import com.integretechpub.mathapplet.DoubleDimension;
import com.integretechpub.mathapplet.DoubleRectangle;
import com.integretechpub.spline.ConflictingPositionException;
import com.integretechpub.spline.Spline;
import com.integretechpub.spline.SplineNode;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.StringTokenizer;

public class Sketching
extends Applet {
    private BufferedSplinePlot plotter;

    public void init() {
        int xGridlines;
        int yGridlines;
        this.setLayout(new BorderLayout());
        String gridlines = this.getParameter("gridlines");
        if (gridlines == null) {
            yGridlines = 4;
            xGridlines = 4;
        } else if (gridlines.indexOf(",") < 0) {
            xGridlines = yGridlines = Integer.parseInt(gridlines.trim());
        } else {
            int k = gridlines.indexOf(",");
            xGridlines = Integer.parseInt(gridlines.substring(0, k).trim());
            yGridlines = Integer.parseInt(gridlines.substring(k + 1).trim());
        }
        double xMin = this.getDoubleParam("xMin", -10.0);
        double xMax = this.getDoubleParam("xMax", 10.0);
        double width = xMax - xMin;
        double xSpace = xGridlines > 0 ? width / (double)xGridlines : 0.0;
        double yMin = this.getDoubleParam("yMin", -10.0);
        double yMax = this.getDoubleParam("yMax", 10.0);
        double height = yMax - yMin;
        double ySpace = yGridlines > 0 ? height / (double)yGridlines : 0.0;
        boolean labeled = "true".equals(this.getParameter("labeled"));
        DoubleRectangle viewport = new DoubleRectangle(xMin - xSpace, yMin - ySpace, width + 2.0 * xSpace, height + 2.0 * ySpace);
        this.plotter = new BufferedSplinePlot(viewport, 20);
        this.plotter.setSplineType(3);
        this.plotter.setBackground(Color.white);
        if (labeled) {
            DoubleDimension d = new DoubleDimension(xSpace == 0.0 ? 10.0 * width : xSpace, ySpace == 0.0 ? 10.0 * height : ySpace);
            this.plotter.setSpacing(12, d);
        } else {
            this.plotter.setPropertyEnabled(12, false);
        }
        this.plotter.getSpline().setRenderNodes(true);
        this.plotter.getSpline().setRenderNodeTangents(false);
        this.plotter.setDecimalPlace(8);
        this.add("Center", (Component)((Object)this.plotter));
        this.readParameters();
    }

    private void readParameters() {
        String response = this.getParameter("response");
        if (response != null) {
            if (response.startsWith("nodes:")) {
                Spline theSpline = this.plotter.getSpline();
                StringTokenizer stz = new StringTokenizer(response.substring(6), ", ");
                while (stz.hasMoreTokens()) {
                    try {
                        double x = Double.valueOf(stz.nextToken());
                        double y = Double.valueOf(stz.nextToken());
                        double m = Double.valueOf(stz.nextToken());
                        theSpline.addNode(new SplineNode(x, y, m));
                    }
                    catch (ConflictingPositionException x) {
                        // empty catch block
                    }
                }
            } else {
                Spline theSpline = this.plotter.getSpline();
                StringTokenizer stz = new StringTokenizer(response, ", ");
                while (stz.hasMoreTokens()) {
                    try {
                        double x = Double.valueOf(stz.nextToken());
                        double y = Double.valueOf(stz.nextToken());
                        theSpline.addNode(new SplineNode(x, y, 1.0));
                    }
                    catch (ConflictingPositionException conflictingPositionException) {
                        // empty catch block
                    }
                    this.plotter.reassignSlopes();
                }
            }
        }
        this.plotter.setLocked("true".equals(this.getParameter("locked")));
    }

    private double getDoubleParam(String name, double dflt) {
        try {
            return Double.valueOf(this.getParameter(name));
        }
        catch (Exception e) {
            return dflt;
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void deleteActiveNode() {
        this.plotter.deleteActiveNode();
        this.plotter.repaint();
    }

    public void deleteAllNodes() {
        this.plotter.removeAllNodes();
        this.plotter.repaint();
    }

    public String getResponse() {
        Spline spl = this.plotter.getSpline();
        spl.sortNodes();
        SplineNode[] nodes = this.plotter.getSpline().getNodes();
        StringBuffer sb = new StringBuffer();
        sb.append("nodes: ");
        if (nodes != null) {
            int i = 0;
            while (i < nodes.length) {
                sb.append(String.valueOf(nodes[i].node.x) + " ");
                sb.append(String.valueOf(nodes[i].node.y) + " ");
                sb.append(String.valueOf(nodes[i].slope) + " ");
                ++i;
            }
        }
        return sb.toString();
    }
}

