/*
 * Decompiled with CFR 0.152.
 */
package applets.proctoredTest;

import applets.util.WarningDialog;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.util.Formatter;

public class Timer
extends Applet
implements Runnable {
    private Thread theThread;
    private Label theLabel;
    private long remainingTime;
    Frame holderFrame = new Frame();
    static final String FIVE_MINUTE_MESSAGE = "You have five minutes remaining. Once the time\nfor your assignment has expired, you will still\nbe able to submit the question you are currently\nworking on, and to have your test graded. But you\nwill not be able to work on any other questions,\nor to log back in to this assignment.";
    static final String EXPIRED_MESSAGE = "Your assignment is now out of time. Please press the\n\"Grade\" button to have your test graded. The system\nwill still accept the work you have done on the\ncurrent question.";

    public void destroy() {
        this.holderFrame.dispose();
        this.holderFrame = null;
    }

    public void init() {
        this.remainingTime = Long.parseLong(this.getParameter("remainingTime"));
        this.setBackground(Color.white);
        this.setForeground(new Color(29, 54, 104));
        this.setLayout(new BorderLayout());
        this.setFont(new Font("Helvetica", 0, 10));
        this.theLabel = new Label("", 2);
        this.add("Center", this.theLabel);
    }

    public void updateTimeDisplay(int hours, int mins, int secs) {
        Formatter formatter = new Formatter();
        String displayCountdown = formatter.format("Remaining Time (hh:mm:ss): %1$02d:%2$02d:%3$02d", hours, mins, secs).toString();
        this.theLabel.setText(displayCountdown);
        this.theLabel.invalidate();
        this.validate();
        System.out.println(displayCountdown);
    }

    public void run() {
        while (true) {
            int hours = this.getHours(this.remainingTime);
            int mins = this.getMinutes(this.remainingTime);
            int secs = this.getSeconds(this.remainingTime);
            this.updateTimeDisplay(hours, mins, secs);
            if (this.remainingTime == 300L) {
                new WarningDialog(this.holderFrame, FIVE_MINUTE_MESSAGE).show();
            } else if (this.remainingTime == 0L) break;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            --this.remainingTime;
        }
        new WarningDialog(this.holderFrame, EXPIRED_MESSAGE).show();
        this.theThread.interrupt();
    }

    private int getSeconds(long time) {
        int secNum = (int)(time % 3600L) % 60;
        return secNum;
    }

    private int getMinutes(long time) {
        int minNum = (int)(time % 3600L) / 60;
        return minNum;
    }

    private int getHours(long time) {
        int hourNum = (int)(time / 3600L);
        return hourNum;
    }

    public void start() {
        this.theThread = new Thread(this);
        this.theThread.start();
    }
}

