/*
 * Decompiled with CFR 0.152.
 */
package applets.grapher;

import applets.grapher.DoublePoint;
import applets.grapher.Function;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class GraphWindow
extends Canvas {
    private static final int MARGIN = 25;
    private Font axesFont = new Font("Arial", 0, 8);
    private DecimalFormat decfmt = new DecimalFormat("#,###.##");
    private DecimalFormat expfmt = new DecimalFormat("0.##E0");
    private double maxDecFmt = 9999.0;
    private double minDecFmt = 0.05;
    private DecimalFormat xfmt;
    private DecimalFormat yfmt;
    private Font labelFont = new Font("Arial", 0, 12);
    protected double xMin;
    protected double xMax;
    protected double xScale;
    protected double yMin;
    protected double yMax;
    protected double yScale;
    protected Color gridColor = new Color(204, 204, 255);
    protected Color axisColor = new Color(80, 80, 80);
    protected boolean xAxisLabel;
    protected boolean yAxisLabel;
    protected boolean showGrid;
    protected Vector functionList = new Vector();
    private Hashtable functionColors = new Hashtable();
    private Hashtable labelList = new Hashtable();
    private static Hashtable colorList = new Hashtable();
    public static final int UNLIMITED = 0;
    public int maxFunctions = 0;
    private Image background;
    private Image offscreen;
    private int lastx;
    private int lasty;

    public GraphWindow(double xMin, double xMax, double yMin, double yMax) {
        this(xMin, xMax, 0.0, yMin, yMax, 0.0);
    }

    public GraphWindow(double xMin, double xMax, double xScale, double yMin, double yMax, double yScale) {
        this.setBackground(Color.white);
        this.xMax = xMax;
        this.xMin = xMin;
        this.yMax = yMax;
        this.yMin = yMin;
        this.xScale = xScale;
        this.yScale = yScale;
        this.xAxisLabel = true;
        this.yAxisLabel = true;
        this.showGrid = true;
        Color c0 = new Color(255, 0, 0);
        Color c1 = new Color(0, 150, 0);
        Color c2 = new Color(0, 0, 220);
        Color c3 = new Color(200, 0, 200);
        Color c4 = new Color(212, 212, 0);
        Color c5 = new Color(0, 125, 125);
        colorList.put(c0, c1);
        colorList.put(c1, c2);
        colorList.put(c2, c3);
        colorList.put(c3, c4);
        colorList.put(c4, c5);
        colorList.put(c5, c0);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                GraphWindow.this.lastx = e.getX();
                GraphWindow.this.lasty = e.getY();
                GraphWindow.this.update(GraphWindow.this.getGraphics());
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                int mods = e.getModifiers();
                int x = e.getX();
                int y = e.getY();
                if ((mods & 1) == 1) {
                    GraphWindow.this.doShift(x, y);
                } else if ((mods & 2) == 2) {
                    GraphWindow.this.doDilate(x, y);
                } else {
                    GraphWindow.this.doTrace(x, y);
                }
                GraphWindow.this.lastx = x;
                GraphWindow.this.lasty = y;
            }
        });
    }

    public GraphWindow() {
        this(-5.0, 5.0, 1.0, -5.0, 5.0, 1.0);
    }

    public void setBackground(Image im) {
        this.background = im;
        this.repaint();
    }

    public void setXFmt(String fmt) {
        this.xfmt = new DecimalFormat(fmt);
    }

    public void setYFmt(String fmt) {
        this.yfmt = new DecimalFormat(fmt);
    }

    public void drawGraph(double xMin, double xMax, double xScale, double yMin, double yMax, double yScale) {
        this.xMax = xMax;
        this.xMin = xMin;
        this.yMax = yMax;
        this.yMin = yMin;
        this.xScale = xScale;
        this.yScale = yScale;
        this.repaint();
    }

    public void drawGraph(double xMin, double xMax, double yMin, double yMax) {
        this.drawGraph(xMin, xMax, 0.0, yMin, yMax, 0.0);
    }

    public void addFunction(Function f, Color c) {
        if (this.maxFunctions != 0 && this.functionList.size() >= this.maxFunctions) {
            this.deleteFunction((Function)this.functionList.elementAt(0));
        }
        this.functionColors.put(f, c);
        this.functionList.addElement(f);
    }

    public void addFunction(Function f) {
        if (this.functionList.size() == 0) {
            this.addFunction(f, (Color)colorList.keys().nextElement());
        } else {
            this.addFunction(f, (Color)colorList.get(this.functionColors.get(this.functionList.lastElement())));
        }
    }

    public void deleteFunction(Function f) {
        this.functionList.removeElement(f);
        this.functionColors.remove(f);
    }

    public void deleteLastFunction() {
        this.deleteFunction((Function)this.functionList.lastElement());
    }

    public void addLabel(double x, double y, String text) {
        this.labelList.put(new DoublePoint(x, y), text);
    }

    public void deleteAll() {
        this.functionColors = new Hashtable();
        this.functionList = new Vector();
        this.repaint();
    }

    public double xMin() {
        return this.xMin;
    }

    public double xMax() {
        return this.xMax;
    }

    public double xScale() {
        return this.xScale;
    }

    public double yMin() {
        return this.yMin;
    }

    public double yMax() {
        return this.yMax;
    }

    public double yScale() {
        return this.yScale;
    }

    public int x(double xValue) {
        return (int)(25.0 + (double)(this.size().width - 50) * (xValue - this.xMin) / (this.xMax - this.xMin) + 0.5);
    }

    public double x(int xCoord) {
        return (this.xMax - this.xMin) * ((double)xCoord - 25.0) / (double)(this.size().width - 50) + this.xMin;
    }

    public int y(double yValue) {
        return (int)(25.0 + (double)(this.size().height - 50) * (this.yMax - yValue) / (this.yMax - this.yMin) + 0.5);
    }

    public double y(int yCoord) {
        return this.yMax - (this.yMax - this.yMin) * ((double)yCoord - 25.0) / (double)(this.size().height - 50);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        if (this.offscreen == null) {
            this.offscreen = this.createImage(this.size().width, this.size().height);
            this.doPaint(this.offscreen.getGraphics());
        }
        g.drawImage(this.offscreen, 0, 0, this.size().width, this.size().width, this);
    }

    private void doPaint(Graphics g) {
        g.setColor(Color.white);
        g.fillRect(0, 0, this.size().width, this.size().height);
        if (this.background != null) {
            g.drawImage(this.background, 0, 0, this);
        }
        if (this.showGrid) {
            this.drawGrid(g);
        }
        this.drawAllFunctions(g);
        this.drawAxes(g);
        this.drawLabels(g);
    }

    private void drawAllFunctions(Graphics g) {
        Enumeration e = this.functionColors.keys();
        while (e.hasMoreElements()) {
            Function f = (Function)e.nextElement();
            this.drawFunction(g, f, (Color)this.functionColors.get(f));
        }
    }

    private void drawLabels(Graphics g) {
        g.setFont(this.labelFont);
        FontMetrics fm = g.getFontMetrics();
        Enumeration e = this.labelList.keys();
        while (e.hasMoreElements()) {
            DoublePoint p = (DoublePoint)e.nextElement();
            String label = (String)this.labelList.get(p);
            this.drawLabel(label, g, this.x(p.x), this.y(p.y));
        }
    }

    private void drawLabel(String label, Graphics g, int x, int y) {
        FontMetrics fm = g.getFontMetrics();
        int width = fm.stringWidth(label);
        int ascent = fm.getAscent();
        int descent = fm.getDescent();
        g.setColor(this.getBackground());
        g.fillRect(x, y - ascent, width, ascent + descent);
        g.setColor(this.getForeground());
        g.drawString(label, x, y);
    }

    private void drawFunction(Graphics g, Function f, Color graphColor) {
        if (this.xMax <= this.xMin || this.yMax <= this.yMin) {
            return;
        }
        int width = this.size().width - 50;
        int height = this.size().height - 50;
        int lastPoint = 0;
        boolean lastPointExists = true;
        g.setColor(graphColor);
        try {
            lastPoint = this.y(f.eval(this.xMin));
        }
        catch (Exception e) {
            lastPointExists = false;
        }
        int i = 25;
        while (i < width + 25) {
            try {
                double x = this.x(i);
                double y = f.eval(x);
                int j = this.y(y);
                if (j < 25 || j > height + 25) {
                    lastPointExists = false;
                } else {
                    if (lastPointExists) {
                        g.drawLine(i - 1, lastPoint, i, j);
                    } else {
                        lastPointExists = true;
                    }
                    lastPoint = j;
                }
            }
            catch (Exception e) {
                lastPointExists = false;
            }
            ++i;
        }
    }

    private void drawAxes(Graphics g) {
        String label;
        int k;
        int hi;
        int lo;
        int width = this.size().width - 50;
        int height = this.size().height - 50;
        FontMetrics theFontMetrics = this.getFontMetrics(this.axesFont);
        g.setFont(this.axesFont);
        g.setColor(this.axisColor);
        int x0 = this.xMin > 0.0 ? 0 : (this.xMax < 0.0 ? this.x(this.xMax) + 4 : this.x(0.0));
        int y0 = this.yMin > 0.0 ? this.y(this.yMin) + 4 : (this.yMax < 0.0 ? 0 : this.y(0.0));
        g.drawLine(x0, this.y(this.yMin), x0, this.y(this.yMax));
        if (this.xAxisLabel) {
            lo = (int)Math.ceil(this.xMin / this.xScale);
            hi = (int)Math.floor(this.xMax / this.xScale);
            k = lo;
            while (k <= hi) {
                double x = this.xScale * (double)k;
                int i = this.x(x);
                label = this.formatX(x);
                int w = theFontMetrics.stringWidth(label);
                if (w < this.x(this.xScale) - this.x(0.0) - 2) {
                    this.drawLabel(label, g, i - w / 2, y0 + 10);
                }
                g.drawLine(i, y0, i, y0 + 2);
                ++k;
            }
        }
        g.drawLine(this.x(this.xMin), y0, this.x(this.xMax), y0);
        if (this.yAxisLabel) {
            lo = (int)Math.ceil(this.yMin / this.yScale);
            hi = (int)Math.floor(this.yMax / this.yScale);
            k = lo;
            while (k <= hi) {
                if (k != 0) {
                    double y = this.yScale * (double)k;
                    int j = this.y(y);
                    label = this.formatY(y);
                    int h = theFontMetrics.getAscent();
                    System.out.println(String.valueOf(h) + " > " + (this.y(0.0) - this.y(this.yScale)) + " (" + this.yScale + ")");
                    if (h < this.y(0.0) - this.y(this.yScale)) {
                        this.drawLabel(label, g, x0 + 6, j + h / 2);
                    }
                    g.drawLine(x0, j, x0 + 2, j);
                }
                ++k;
            }
        }
    }

    private void drawGrid(Graphics g) {
        g.setColor(this.gridColor);
        int min = this.y(this.yMin);
        int max = this.y(this.yMax);
        int lo = (int)Math.ceil(this.xMin / this.xScale);
        int hi = (int)Math.floor(this.xMax / this.xScale);
        int k = lo;
        while (k <= hi) {
            int i = this.x(this.xScale * (double)k);
            g.drawLine(i, min, i, max);
            ++k;
        }
        min = this.x(this.xMin);
        max = this.x(this.xMax);
        lo = (int)Math.ceil(this.yMin / this.yScale);
        hi = (int)Math.floor(this.yMax / this.yScale);
        k = lo;
        while (k <= hi) {
            int j = this.y(this.yScale * (double)k);
            g.drawLine(min, j, max, j);
            ++k;
        }
    }

    private void doTrace(int x, int y) {
        String label = "(" + this.formatX(this.x(x -= 4)) + ", " + this.formatY(this.y(y -= 4)) + ")";
        Graphics g = this.getGraphics();
        this.update(g);
        g.setFont(this.labelFont);
        this.drawLabel(label, g, x + 10, y + 3);
        g.drawLine(x - 5, y, x - 2, y);
        g.drawLine(x + 2, y, x + 5, y);
        g.drawLine(x, y - 5, x, y - 2);
        g.drawLine(x, y + 2, x, y + 5);
    }

    private void doShift(int x, int y) {
        double dx = this.x(x) - this.x(this.lastx);
        double dy = this.y(y) - this.y(this.lasty);
        this.xMin -= dx;
        this.xMax -= dx;
        this.yMin -= dy;
        this.yMax -= dy;
        this.offscreen = null;
        this.update(this.getGraphics());
    }

    private void doDilate(int x, int y) {
        int w2 = this.size().width / 2;
        int h2 = this.size().height / 2;
        int i = this.lastx - w2;
        int j = this.lasty - h2;
        double r1 = Math.sqrt(i * i + j * j);
        i = x - w2;
        j = y - h2;
        double r2 = Math.sqrt(i * i + j * j);
        double q = r2 / r1;
        double xMid = (this.xMin + this.xMax) / 2.0;
        double yMid = (this.yMin + this.yMax) / 2.0;
        this.xMin = xMid + q * (this.xMin - xMid);
        this.xMax = xMid + q * (this.xMax - xMid);
        this.yMin = yMid + q * (this.yMin - yMid);
        this.yMax = yMid + q * (this.yMax - yMid);
        this.offscreen = null;
        this.update(this.getGraphics());
    }

    private String formatX(double x) {
        if (this.xfmt != null) {
            return this.xfmt.format(x);
        }
        return this.format(x);
    }

    private String formatY(double y) {
        if (this.yfmt != null) {
            return this.yfmt.format(y);
        }
        return this.format(y);
    }

    private String format(double x) {
        double a = Math.abs(x);
        if (a == 0.0) {
            return "0";
        }
        if (a < this.minDecFmt) {
            return this.expfmt.format(x);
        }
        if (a > this.maxDecFmt) {
            return this.expfmt.format(x);
        }
        return this.decfmt.format(x);
    }
}

