/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mapleta.hotfix.installer;

import com.maplesoft.mapleta.hotfix.installer.Platform;
import com.maplesoft.mapleta.hotfix.installer.WorkingFolderManager;
import java.io.File;
import java.util.regex.Pattern;

public class CommandLineInfo {
    private static String revertParmPattern = "((--?)|(/))revert";
    private static String forceParmPattern = "((--?)|(/))force";
    private static String debugParmPattern = "((--?)|(/))debug";
    private static String helpParmPattern = "((--?)|(/))((help)|(\\?))";
    private boolean revert = false;
    private boolean force = false;
    private boolean debug = false;
    private String specifiedForceParameterName = Platform.IsWindows() ? "/force" : "--force";

    public boolean isRevert() {
        return this.revert;
    }

    public boolean isInstall() {
        return !this.isRevert();
    }

    public boolean isForce() {
        return this.force;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public String getSpecifiedForceParameterName() {
        return this.specifiedForceParameterName;
    }

    public CommandLineInfo(String[] args) throws Exception {
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (Pattern.matches(revertParmPattern, arg)) {
                this.revert = true;
            } else if (Pattern.matches(forceParmPattern, arg)) {
                this.force = true;
                this.specifiedForceParameterName = arg;
            } else if (Pattern.matches(debugParmPattern, arg)) {
                this.debug = true;
            } else if (Pattern.matches(helpParmPattern, arg)) {
                this.Usage();
                System.exit(0);
            } else {
                System.out.format("Hotfix Installer: invalid argument '%s'.\n", arg);
                this.Usage();
                System.exit(4);
            }
            ++n2;
        }
        if (this.revert && this.force) {
            throw new Exception("You may not specify both 'revert' and 'force'.");
        }
        boolean haveBackups = !WorkingFolderManager.isBackupFolderEmpty();
        String backupFolderPath = new File(WorkingFolderManager.getBackupFolder()).getAbsolutePath();
        if (!this.revert && !this.force && haveBackups) {
            throw new Exception(String.format("Hotfix installation requires backing up the targets but the backup folder '%s' is not empty. Empty the backup folder or suppress backup with %sforce.", backupFolderPath, Platform.IsWindows() ? "/" : "--"));
        }
        if (this.revert && !haveBackups) {
            throw new Exception(String.format("You have specified 'revert' but the backup folder '%s' is empty.", backupFolderPath));
        }
    }

    private void Usage() {
        if (Platform.IsWindows()) {
            System.out.println("use: install [/revert] /[force]");
        } else {
            System.out.println("use: ./install.sh [--revert] [--force]");
        }
    }
}

