/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mapleta.hotfix.installer;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class Logger {
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private String path;
    private boolean writeToConsole = true;

    public void setWriteToConsole(boolean writeToConsole) {
        this.writeToConsole = writeToConsole;
    }

    public Logger(String path) {
        this.path = path;
    }

    public void Log(String msg) {
        Date date = Calendar.getInstance().getTime();
        String stampedMsg = String.format("%s %s", dateFormat.format(date), msg);
        if (this.writeToConsole) {
            System.out.println(stampedMsg);
        }
        if (this.path == null) {
            return;
        }
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.path, true));
            writer.write(stampedMsg);
            writer.newLine();
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

