<%@ page contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" language="java"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html"%>
<%@ taglib uri="http://struts.apache.org/tags-tiles" prefix="tiles"%>
<%@ taglib uri="http://displaytag.sf.net" prefix="display" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>

<html:messages id="msg" message="false">
	<span class="errorStyle1"><c:out value='${msg}' /></span>
	<br>
</html:messages>

<fmt:bundle basename="com.maplesoft.mapleta.classmanager.ApplicationResources">
	<table border=0 width="80%">
		<tr>
			<td colspan="4">
				<em class="divider">
					<fmt:message key="classmanager.selfregister.label" />
				</em>
			</td>
		</tr>
	</table>
	<div>
		<em class="title">
		<fmt:message key="classmanager.selfregister.msg"/>
		</em>
	</div>
	<html:form method="post" action="/SelfRegistration.do">
		<br />
		<b>
			<fmt:message key="ClassManagerSearchForm.user.search.label" />
		</b>
		<html:text property="searchString" size="40" />
		<html:submit styleClass="button">
			<fmt:message key="ClassManagerSearchForm.user.search.label" />
		</html:submit>
	</html:form>
	<html:form method="post" action="/SelfRegistration.do">
		<html:hidden property="mode" value="confirm" />
		<c:choose>
			<c:when test="${fn:length(model.classList) > 0}">
				<br/>
				<em class="title">
					<fmt:message key="classmanager.selfregistertable.msg"/>
				</em>
				<display:table id="row" name="${model.classList}" defaultsort="2" requestURI="/classmanager/SelfRegistration.do" sort="list" class="simple">
					<display:column title="">
						<html:multibox property="selectedItems" value="${row.cid}" />
					</display:column>
					<display:column titleKey="classmanager.selfregister.table.name.label" sortable="true">${row.name}</display:column>
					<display:column titleKey="classmanager.selfregister.table.instructor.label" sortable="true">${row.instructor.givenName} ${row.instructor.sn}</display:column>
				</display:table>
				<input type="button" class="button" value="Cancel" onclick="document.location.href='<%= request.getContextPath() %>/Homepage.do'" />
				<html:submit styleClass="button">
					<fmt:message key="classmanager.selfregister.button"/>
				</html:submit>	
			</c:when>
			<c:otherwise>
				<br/>
				<em class="title">
					<fmt:message key="classmanager.selfregister.no_match.msg" />
				</em>
				<br />
				<br />
				<input type="button" class="button" value="Cancel" onclick="document.location.href='<%= request.getContextPath() %>/Homepage.do'" />
			</c:otherwise>
		</c:choose>
	</html:form>
</fmt:bundle>
